/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookingAtElement {
    private final int borderColor;
    private final int textColor;

    protected LookingAtElement(int borderColor, int textColor) {
        this.borderColor = borderColor;
        this.textColor = textColor;
    }

    public void render(@NotNull PoseStack matrix, int x, int y) {
        int scale;
        int width = this.getWidth();
        int height = this.getHeight();
        GuiComponent.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + width - 1), (int)(y + 1), (int)this.borderColor);
        GuiComponent.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + 1), (int)(y + height - 1), (int)this.borderColor);
        GuiComponent.m_93172_((PoseStack)matrix, (int)(x + width - 1), (int)y, (int)(x + width), (int)(y + height - 1), (int)this.borderColor);
        GuiComponent.m_93172_((PoseStack)matrix, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)this.borderColor);
        TextureAtlasSprite icon = this.getIcon();
        if (icon != null && (scale = this.getScaledLevel(width - 2)) > 0) {
            boolean colored = this.applyRenderColor();
            GuiUtils.drawTiledSprite(matrix, x + 1, y + 1, height - 2, scale, height - 2, icon, 16, 16, 0, GuiUtils.TilingDirection.DOWN_RIGHT);
            if (colored) {
                MekanismRenderer.resetColor();
            }
        }
        LookingAtElement.renderScaledText(Minecraft.m_91087_(), matrix, x + 4, y + 3, this.textColor, width - 8, this.getText());
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 13;
    }

    public abstract int getScaledLevel(int var1);

    @Nullable
    public abstract TextureAtlasSprite getIcon();

    public abstract Component getText();

    protected boolean applyRenderColor() {
        return false;
    }

    public static void renderScaledText(Minecraft mc, @NotNull PoseStack matrix, float x, float y, int color, float maxWidth, Component component) {
        int length = mc.f_91062_.m_92852_((FormattedText)component);
        if ((float)length <= maxWidth) {
            mc.f_91062_.m_92889_(matrix, component, x, y, color);
        } else {
            float scale = maxWidth / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            matrix.m_85836_();
            matrix.m_85841_(scale, scale, scale);
            mc.f_91062_.m_92889_(matrix, component, (float)((int)(x * reverse)), (float)((int)(y * reverse + yAdd)), color);
            matrix.m_85849_();
        }
        MekanismRenderer.resetColor();
    }
}

