/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.curios;

import java.util.Optional;
import java.util.function.Predicate;
import mekanism.client.render.MekanismCurioRenderer;
import mekanism.client.render.armor.ISpecialGear;
import mekanism.common.Mekanism;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.RegistryUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

public class CuriosIntegration {
    public static void sendIMC() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
    }

    public static void addListeners(IEventBus bus) {
        bus.addListener(event -> CuriosIntegration.registerRenderers(MekanismItems.JETPACK, MekanismItems.ARMORED_JETPACK));
    }

    private static void registerRenderers(ItemLike ... items) {
        for (ItemLike item : items) {
            ArmorItem armor;
            Item item2 = item.m_5456_();
            if (item2 instanceof ArmorItem && (item2 = IClientItemExtensions.of((Item)(armor = (ArmorItem)item2))) instanceof ISpecialGear) {
                ISpecialGear gear = (ISpecialGear)item2;
                CuriosRendererRegistry.register((Item)armor, () -> new MekanismCurioRenderer(gear.getGearModel(armor.m_40402_())));
                continue;
            }
            Mekanism.logger.warn("Attempted to register Curios renderer for non-special gear item: {}.", (Object)RegistryUtils.getName(item.m_5456_()));
        }
    }

    public static Optional<? extends IItemHandler> getCuriosInventory(LivingEntity entity) {
        return CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve();
    }

    public static Optional<SlotResult> findFirstCurioAsResult(@NotNull LivingEntity entity, Predicate<ItemStack> filter) {
        return CuriosApi.getCuriosHelper().findFirstCurio(entity, filter);
    }

    public static ItemStack findFirstCurio(@NotNull LivingEntity entity, Predicate<ItemStack> filter) {
        return CuriosIntegration.findFirstCurioAsResult(entity, filter).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    public static ItemStack getCurioStack(@NotNull LivingEntity entity, String slotType, int slot) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).resolve().flatMap(handler -> handler.getStacksHandler(slotType)).map(handler -> handler.getStacks().getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }
}

