/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical.attribute.gas;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=GasAttributes.Fuel.class, zenCodeName="mods.mekanism.attribute.gas.FuelAttribute")
public class CrTFuelAttribute {
    private CrTFuelAttribute() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasAttributes.Fuel create(int burnTicks, FloatingLong energyDensity) {
        if (burnTicks <= 0) {
            throw new IllegalArgumentException("Fuel attributes must burn for at least one tick! Burn Ticks: " + burnTicks);
        }
        if (energyDensity.isZero()) {
            throw new IllegalArgumentException("Fuel attributes must have an energy density greater than zero!");
        }
        FloatingLong density = energyDensity.copyAsConst();
        return new GasAttributes.Fuel(() -> burnTicks, () -> density);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="burnTicks")
    public static int getBurnTicks(GasAttributes.Fuel _this) {
        return _this.getBurnTicks();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="energyPerTick")
    public static FloatingLong getEnergyPerTick(GasAttributes.Fuel _this) {
        return _this.getEnergyPerTick();
    }
}

