/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.opencomputers2;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import li.cil.oc2.api.bus.device.rpc.RPCInvocation;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.computer.ComputerArgumentHandler;
import mekanism.common.integration.computer.ComputerException;
import org.jetbrains.annotations.Nullable;

public class OC2ArgumentWrapper
extends ComputerArgumentHandler<ComputerException, Object> {
    private final RPCInvocation invocation;

    OC2ArgumentWrapper(RPCInvocation invocation) {
        this.invocation = invocation;
    }

    @Override
    public int getCount() {
        return this.invocation.getParameters().size();
    }

    @Override
    public ComputerException error(String messageFormat, Object ... args) {
        return new ComputerException(this.formatError(messageFormat, args));
    }

    @Nullable
    public JsonElement getArgument(int index) {
        return this.invocation.getParameters().get(index);
    }

    @Override
    public Object sanitizeArgument(Class<?> expectedType, Class<?> argumentType, Object argument) {
        if (argument instanceof JsonElement) {
            JsonElement element = (JsonElement)argument;
            if (expectedType == FloatingLong.class && element.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
                if (jsonPrimitive.isNumber()) {
                    Number number = jsonPrimitive.getAsNumber();
                    if (number instanceof FloatingLong) {
                        FloatingLong fl = (FloatingLong)number;
                        return fl;
                    }
                    if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
                        long value = number.longValue();
                        if (value < 0L) {
                            return FloatingLong.ZERO;
                        }
                        return FloatingLong.createConst(value);
                    }
                    return FloatingLong.createConst(number.doubleValue());
                }
                if (jsonPrimitive.isString()) {
                    try {
                        return FloatingLong.parseFloatingLong(jsonPrimitive.getAsString());
                    }
                    catch (NumberFormatException e) {
                        return super.sanitizeArgument(expectedType, argumentType, argument);
                    }
                }
            }
            try {
                return this.invocation.getGson().fromJson(element, expectedType);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.sanitizeArgument(expectedType, argumentType, argument);
    }

    @Override
    public Object noResult() {
        return null;
    }

    @Override
    public Object wrapResult(Object result) {
        if (result instanceof FloatingLong) {
            FloatingLong fl = (FloatingLong)result;
            return fl.doubleValue();
        }
        return result;
    }

    static Class<?> wrapType(Class<?> clazz) {
        if (clazz == FloatingLong.class) {
            return Double.TYPE;
        }
        return clazz;
    }
}

