/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.advancements.triggers;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.MekanismAPI;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.robit.RobitSkin;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeRobitSkinTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private final ResourceLocation id;

    public ChangeRobitSkinTrigger(ResourceLocation id) {
        this.id = id;
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    @NotNull
    protected TriggerInstance createInstance(@NotNull JsonObject json, @NotNull EntityPredicate.Composite playerPredicate, @NotNull DeserializationContext context) {
        RobitSkin skin;
        if (json.has("skin")) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"skin");
            ResourceLocation registryName = ResourceLocation.m_135820_((String)name);
            if (registryName == null) {
                throw new JsonSyntaxException("Expected property 'skin' to be a valid resource location, was: '" + name + "'.");
            }
            IForgeRegistry<RobitSkin> registry = MekanismAPI.robitSkinRegistry();
            if (!registry.containsKey(registryName)) {
                throw new JsonSyntaxException("No robit skin registered for name '" + registryName + "'.");
            }
            skin = (RobitSkin)registry.getValue(registryName);
        } else {
            skin = null;
        }
        return new TriggerInstance(playerPredicate, skin);
    }

    public void trigger(ServerPlayer player, RobitSkin skin) {
        this.m_66234_(player, instance -> instance.skin == null || instance.skin == skin);
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final RobitSkin skin;

        public TriggerInstance(EntityPredicate.Composite playerPredicate, @Nullable RobitSkin skin) {
            super(MekanismCriteriaTriggers.CHANGE_ROBIT_SKIN.m_7295_(), playerPredicate);
            this.skin = skin;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.skin != null) {
                json.addProperty("skin", this.skin.getRegistryName().toString());
            }
            return json;
        }

        public static TriggerInstance toAny() {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, null);
        }

        public static TriggerInstance toSkin(IRobitSkinProvider skinProvider) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, skinProvider.getSkin());
        }
    }
}

