/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.Vertex;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class QuadUtils {
    private static final float eps = 0.00390625f;

    private QuadUtils() {
    }

    public static List<Quad> unpack(List<BakedQuad> quads) {
        return quads.stream().map(Quad::new).toList();
    }

    public static List<BakedQuad> bake(List<Quad> quads) {
        return quads.stream().map(Quad::bake).toList();
    }

    public static List<Quad> flip(List<Quad> quads) {
        return quads.stream().map(Quad::flip).toList();
    }

    public static List<Quad> transformQuads(List<Quad> orig, QuadTransformation transformation) {
        ArrayList<Quad> list = new ArrayList<Quad>(orig.size());
        for (Quad quad : orig) {
            transformation.transform(quad);
            list.add(quad);
        }
        return list;
    }

    public static List<BakedQuad> transformBakedQuads(List<BakedQuad> orig, QuadTransformation transformation) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>(orig.size());
        for (BakedQuad bakedQuad : orig) {
            Quad quad = new Quad(bakedQuad);
            if (transformation.transform(quad)) {
                list.add(quad.bake());
                continue;
            }
            list.add(bakedQuad);
        }
        return list;
    }

    public static List<BakedQuad> transformAndBake(List<Quad> orig, QuadTransformation transformation) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>(orig.size());
        for (Quad quad : orig) {
            transformation.transform(quad);
            list.add(quad.bake());
        }
        return list;
    }

    public static void remapUVs(Quad quad, TextureAtlasSprite newTexture) {
        TextureAtlasSprite texture = quad.getTexture();
        float uMin = texture.m_118409_();
        float uMax = texture.m_118410_();
        float vMin = texture.m_118411_();
        float vMax = texture.m_118412_();
        quad.vertexTransform(v -> {
            float newU = (v.getTexU() - uMin) * 16.0f / (uMax - uMin);
            float newV = (v.getTexV() - vMin) * 16.0f / (vMax - vMin);
            v.texRaw(newTexture.m_118367_((double)newU), newTexture.m_118393_((double)newV));
        });
    }

    public static void contractUVs(Quad quad) {
        TextureAtlasSprite texture = quad.getTexture();
        float sizeX = (float)texture.m_118405_() / (texture.m_118410_() - texture.m_118409_());
        float sizeY = (float)texture.m_118408_() / (texture.m_118412_() - texture.m_118411_());
        float ep = 1.0f / (Math.max(sizeX, sizeY) * 256.0f);
        float[] newUs = QuadUtils.contract(quad, Vertex::getTexU, ep);
        float[] newVs = QuadUtils.contract(quad, Vertex::getTexV, ep);
        for (int i = 0; i < quad.getVertices().length; ++i) {
            quad.getVertices()[i].texRaw(newUs[i], newVs[i]);
        }
    }

    private static float[] contract(Quad quad, Function<Vertex, Float> uvf, float ep) {
        int v;
        float center = 0.0f;
        float[] ret = new float[4];
        for (v = 0; v < 4; ++v) {
            center += uvf.apply(quad.getVertices()[v]).floatValue();
        }
        center /= 4.0f;
        for (v = 0; v < 4; ++v) {
            float shifted;
            float orig = uvf.apply(quad.getVertices()[v]).floatValue();
            float delta = orig - (shifted = orig * 0.99609375f + center * 0.00390625f);
            if (Math.abs(delta) < ep) {
                float centerDelta = Math.abs(orig - center);
                shifted = centerDelta < 2.0f * ep ? (orig + center) / 2.0f : orig + (delta < 0.0f ? ep : -ep);
            }
            ret[v] = shifted;
        }
        return ret;
    }
}

