/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.function.Predicate;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IHUDElement;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HUDRenderer {
    private static final EquipmentSlot[] EQUIPMENT_ORDER = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    private static final ResourceLocation[] ARMOR_ICONS = new ResourceLocation[]{MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_helmet.png"), MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_chest.png"), MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_leggings.png"), MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_boots.png")};
    private static final ResourceLocation TOOL_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekatool.png");
    private static final ResourceLocation COMPASS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "compass.png");
    private long lastTick = -1L;
    private float prevRotationYaw;
    private float prevRotationPitch;

    public void renderHUD(PoseStack matrix, float partialTick, int screenWidth, int screenHeight, int maxTextHeight, boolean reverseHud) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        this.update((Level)minecraft.f_91073_, (Player)player);
        if (MekanismConfig.client.hudOpacity.get() < 0.05f) {
            return;
        }
        Font font = minecraft.f_91062_;
        int color = HUDElement.HUDColor.REGULAR.getColorARGB();
        matrix.m_85836_();
        float yawJitter = -HUDRenderer.absSqrt(player.f_20885_ - this.prevRotationYaw);
        float pitchJitter = -HUDRenderer.absSqrt(player.m_146909_() - this.prevRotationPitch);
        matrix.m_85837_((double)yawJitter, (double)pitchJitter, 0.0);
        if (MekanismConfig.client.hudCompassEnabled.get()) {
            this.renderCompass((Player)player, font, matrix, partialTick, screenWidth, screenHeight, maxTextHeight, reverseHud, color);
        }
        this.renderMekaSuitEnergyIcons((Player)player, font, matrix, color);
        this.renderMekaSuitModuleIcons((Player)player, font, matrix, screenWidth, screenHeight, reverseHud, color);
        matrix.m_85849_();
    }

    private void update(Level level, Player player) {
        if (this.lastTick == -1L || level.m_46467_() - this.lastTick > 1L) {
            this.prevRotationYaw = player.m_146908_();
            this.prevRotationPitch = player.m_146909_();
        }
        this.lastTick = level.m_46467_();
        float yawDiff = player.f_20885_ - this.prevRotationYaw;
        float pitchDiff = player.m_146909_() - this.prevRotationPitch;
        float jitter = MekanismConfig.client.hudJitter.get();
        this.prevRotationYaw += yawDiff / jitter;
        this.prevRotationPitch += pitchDiff / jitter;
    }

    private static float absSqrt(float val) {
        float ret = (float)Math.sqrt(Math.abs(val));
        return val < 0.0f ? -ret : ret;
    }

    private void renderMekaSuitEnergyIcons(Player player, Font font, PoseStack matrix, int color) {
        matrix.m_85836_();
        matrix.m_85837_(10.0, 10.0, 0.0);
        int posX = 0;
        Predicate<Item> showArmorPercent = item -> item instanceof ItemMekaSuitArmor;
        for (int i = 0; i < EnumUtils.ARMOR_SLOTS.length; ++i) {
            posX += this.renderEnergyIcon(player, font, matrix, posX, color, ARMOR_ICONS[i], EnumUtils.ARMOR_SLOTS[i], showArmorPercent);
        }
        Predicate<Item> showToolPercent = item -> item instanceof ItemMekaTool;
        for (EquipmentSlot hand : EnumUtils.HAND_SLOTS) {
            posX += this.renderEnergyIcon(player, font, matrix, posX, color, TOOL_ICON, hand, showToolPercent);
        }
        matrix.m_85849_();
    }

    private int renderEnergyIcon(Player player, Font font, PoseStack matrix, int posX, int color, ResourceLocation icon, EquipmentSlot slot, Predicate<Item> showPercent) {
        ItemStack stack = player.m_6844_(slot);
        if (showPercent.test(stack.m_41720_())) {
            this.renderHUDElement(font, matrix, posX, 0, MekanismAPI.getModuleHelper().hudElementPercent(icon, StorageUtils.getEnergyRatio(stack)), color, false);
            return 48;
        }
        return 0;
    }

    private void renderMekaSuitModuleIcons(Player player, Font font, PoseStack matrix, int screenWidth, int screenHeight, boolean reverseHud, int color) {
        int startX = screenWidth - 10;
        int curY = screenHeight - 10;
        matrix.m_85836_();
        for (EquipmentSlot type : EQUIPMENT_ORDER) {
            ItemStack stack = player.m_6844_(type);
            Item item = stack.m_41720_();
            if (!(item instanceof IModuleContainerItem)) continue;
            IModuleContainerItem item2 = (IModuleContainerItem)item;
            for (IHUDElement element : item2.getHUDElements(player, stack)) {
                curY -= 18;
                if (reverseHud) {
                    this.renderHUDElement(font, matrix, 10, curY, element, color, false);
                    continue;
                }
                int elementWidth = 24 + font.m_92852_((FormattedText)element.getText());
                this.renderHUDElement(font, matrix, startX - elementWidth, curY, element, color, true);
            }
        }
        matrix.m_85849_();
    }

    private void renderHUDElement(Font font, PoseStack matrix, int x, int y, IHUDElement element, int color, boolean iconRight) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        MekanismRenderer.color(color);
        RenderSystem.m_157456_((int)0, (ResourceLocation)element.getIcon());
        GuiComponent.m_93133_((PoseStack)matrix, (int)(iconRight ? x + font.m_92852_((FormattedText)element.getText()) + 2 : x), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        MekanismRenderer.resetColor();
        font.m_92889_(matrix, element.getText(), iconRight ? (float)x : (float)(x + 18), (float)(y + 5), element.getColor());
    }

    private void renderCompass(Player player, Font font, PoseStack matrix, float partialTick, int screenWidth, int screenHeight, int maxTextHeight, boolean reverseHud, int color) {
        int posX = reverseHud ? screenWidth - 125 : 25;
        int posY = Math.min(screenHeight - 20, maxTextHeight) - 80;
        matrix.m_85836_();
        matrix.m_85837_((double)(posX + 50), (double)(posY + 50), 0.0);
        matrix.m_85836_();
        matrix.m_85836_();
        matrix.m_85841_(0.7f, 0.7f, 0.7f);
        MutableComponent coords = MekanismLang.GENERIC_BLOCK_POS.translate(player.m_146903_(), player.m_146904_(), player.m_146907_());
        font.m_92889_(matrix, (Component)coords, (float)(-font.m_92852_((FormattedText)coords)) / 2.0f, -4.0f, color);
        matrix.m_85849_();
        float angle = 180.0f - player.m_5675_(partialTick);
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(-60.0f));
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(angle));
        RenderSystem.m_157456_((int)0, (ResourceLocation)COMPASS);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        MekanismRenderer.color(color);
        GuiComponent.m_93160_((PoseStack)matrix, (int)-50, (int)-50, (int)100, (int)100, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
        this.rotateStr(font, matrix, MekanismLang.NORTH_SHORT, angle, 0.0f, color);
        this.rotateStr(font, matrix, MekanismLang.EAST_SHORT, angle, 90.0f, color);
        this.rotateStr(font, matrix, MekanismLang.SOUTH_SHORT, angle, 180.0f, color);
        this.rotateStr(font, matrix, MekanismLang.WEST_SHORT, angle, 270.0f, color);
        MekanismRenderer.resetColor();
        matrix.m_85849_();
        matrix.m_85849_();
    }

    private void rotateStr(Font font, PoseStack matrix, ILangEntry langEntry, float rotation, float shift, int color) {
        matrix.m_85836_();
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(shift));
        matrix.m_85837_(0.0, -50.0, 0.0);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(-rotation - shift));
        font.m_92889_(matrix, (Component)langEntry.translate(new Object[0]), -2.5f, -4.0f, color);
        matrix.m_85849_();
    }
}

