/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiElement
extends AbstractWidget
implements IFancyFontRenderer {
    private static final int BUTTON_TEX_X = 200;
    private static final int BUTTON_TEX_Y = 60;
    public static final ResourceLocation WARNING_BACKGROUND_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "warning_background.png");
    public static final ResourceLocation WARNING_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "warning.png");
    public static final Minecraft minecraft = Minecraft.m_91087_();
    protected ButtonBackground buttonBackground = ButtonBackground.NONE;
    protected final List<GuiElement> children = new ArrayList<GuiElement>();
    private final List<GuiElement> positionOnlyChildren = new ArrayList<GuiElement>();
    private IGuiWrapper guiObj;
    @Nullable
    protected SoundEvent clickSound;
    protected int relativeX;
    protected int relativeY;
    public boolean isOverlay;

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height) {
        this(gui, x, y, width, height, (Component)Component.m_237119_());
    }

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height, Component text) {
        super(gui.getLeft() + x, gui.getTop() + y, width, height, text);
        this.relativeX = x;
        this.relativeY = y;
        this.guiObj = gui;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
    }

    public int getRelativeX() {
        return this.relativeX;
    }

    public int getRelativeY() {
        return this.relativeY;
    }

    public void transferToNewGui(IGuiWrapper gui) {
        int prevLeft = this.getGuiLeft();
        int prevTop = this.getGuiTop();
        this.transferToNewGuiInternal(gui);
        this.resize(prevLeft, prevTop, this.getGuiLeft(), this.getGuiTop());
    }

    private void transferToNewGuiInternal(IGuiWrapper gui) {
        this.guiObj = gui;
        this.children.forEach(child -> child.transferToNewGuiInternal(gui));
        this.positionOnlyChildren.forEach(child -> child.transferToNewGuiInternal(gui));
    }

    protected <ELEMENT extends GuiElement> ELEMENT addChild(ELEMENT element) {
        this.children.add(element);
        if (this.isOverlay) {
            element.isOverlay = true;
        }
        return element;
    }

    protected <ELEMENT extends GuiElement> ELEMENT addPositionOnlyChild(ELEMENT element) {
        this.positionOnlyChildren.add(element);
        return element;
    }

    public final IGuiWrapper gui() {
        return this.guiObj;
    }

    public final int getGuiLeft() {
        return this.guiObj.getLeft();
    }

    public final int getGuiTop() {
        return this.guiObj.getTop();
    }

    public final int getGuiWidth() {
        return this.guiObj.getWidth();
    }

    public final int getGuiHeight() {
        return this.guiObj.getHeight();
    }

    public List<GuiElement> children() {
        return this.children;
    }

    public void tick() {
        this.children.forEach(GuiElement::tick);
    }

    public void resize(int prevLeft, int prevTop, int left, int top) {
        this.f_93620_ = this.f_93620_ - prevLeft + left;
        this.f_93621_ = this.f_93621_ - prevTop + top;
        this.children.forEach(child -> child.resize(prevLeft, prevTop, left, top));
        this.positionOnlyChildren.forEach(child -> child.resize(prevLeft, prevTop, left, top));
    }

    public boolean childrenContainsElement(Predicate<GuiElement> checker) {
        return this.children.stream().anyMatch(e -> e.containsElement(checker));
    }

    public boolean containsElement(Predicate<GuiElement> checker) {
        return checker.test(this) || this.childrenContainsElement(checker);
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
    }

    public boolean m_5755_(boolean focused) {
        if (this.f_93623_ && this.f_93624_) {
            this.m_93692_(!this.m_93696_());
            boolean isFocused = this.m_93696_();
            this.m_7207_(isFocused);
            return isFocused;
        }
        return false;
    }

    public void move(int changeX, int changeY) {
        this.f_93620_ += changeX;
        this.f_93621_ += changeY;
        this.relativeX += changeX;
        this.relativeY += changeY;
        this.children.forEach(child -> child.move(changeX, changeY));
        this.positionOnlyChildren.forEach(child -> child.move(changeX, changeY));
    }

    public void onWindowClose() {
        this.children.forEach(GuiElement::onWindowClose);
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    protected IHoverable getOnHover(ILangEntry translationHelper) {
        return this.getOnHover(() -> translationHelper.translate(new Object[0]));
    }

    protected IHoverable getOnHover(Supplier<Component> componentSupplier) {
        return (onHover, matrix, mouseX, mouseY) -> this.displayTooltips(matrix, mouseX, mouseY, (Component)componentSupplier.get());
    }

    public boolean hasPersistentData() {
        return this.children.stream().anyMatch(GuiElement::hasPersistentData);
    }

    public void syncFrom(GuiElement element) {
        int numChildren = this.children.size();
        if (numChildren > 0) {
            for (int i = 0; i < element.children.size(); ++i) {
                GuiElement child;
                GuiElement prevChild = element.children.get(i);
                if (!prevChild.hasPersistentData() || i >= numChildren || (child = this.children.get(i)).getClass() != prevChild.getClass()) continue;
                child.syncFrom(prevChild);
            }
        }
    }

    public final void onRenderForeground(PoseStack matrix, int mouseX, int mouseY, int zOffset, int totalOffset) {
        if (this.f_93624_) {
            matrix.m_85837_(0.0, 0.0, (double)zOffset);
            GuiMekanism.maxZOffset = Math.max(totalOffset, GuiMekanism.maxZOffset);
            matrix.m_85837_((double)(-this.getGuiLeft()), (double)(-this.getGuiTop()), 0.0);
            this.renderBackgroundOverlay(matrix, mouseX, mouseY);
            this.children.forEach(child -> child.m_6305_(matrix, mouseX, mouseY, 0.0f));
            this.children.forEach(child -> child.onDrawBackground(matrix, mouseX, mouseY, 0.0f));
            matrix.m_85837_((double)this.getGuiLeft(), (double)this.getGuiTop(), 0.0);
            this.renderForeground(matrix, mouseX, mouseY);
            this.children.forEach(child -> {
                matrix.m_85836_();
                child.onRenderForeground(matrix, mouseX, mouseY, 50, totalOffset + 50);
                matrix.m_85849_();
            });
        }
    }

    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        this.drawButtonText(matrix, mouseX, mouseY);
    }

    public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
    }

    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.children.stream().filter(child -> child.m_5953_(mouseX, mouseY)).forEach(child -> child.m_7428_(matrix, mouseX, mouseY));
    }

    public void displayTooltips(PoseStack matrix, int mouseX, int mouseY, Component ... components) {
        this.guiObj.displayTooltips(matrix, mouseX, mouseY, components);
    }

    public void displayTooltips(PoseStack matrix, int mouseX, int mouseY, List<Component> components) {
        this.guiObj.displayTooltips(matrix, mouseX, mouseY, components);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (GuiUtils.checkChildren(this.children, child -> child.m_6375_(mouseX, mouseY, button))) {
            return true;
        }
        if (this.f_93623_ && this.f_93624_ && this.m_7972_(button) && this.m_93680_(mouseX, mouseY)) {
            this.m_7435_(minecraft.m_91106_());
            this.onClick(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    public final void m_5716_(double mouseX, double mouseY) {
        this.onClick(mouseX, mouseY, 0);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.m_5716_(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children, child -> child.m_7933_(keyCode, scanCode, modifiers)) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char c, int keyCode) {
        return GuiUtils.checkChildren(this.children, child -> child.m_5534_(c, keyCode)) || super.m_5534_(c, keyCode);
    }

    public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.children.forEach(element -> element.m_7212_(mouseX, mouseY, deltaX, deltaY));
        super.m_7212_(mouseX, mouseY, deltaX, deltaY);
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.children.forEach(element -> element.m_7691_(mouseX, mouseY));
        super.m_7691_(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return GuiUtils.checkChildren(this.children, child -> child.m_6050_(mouseX, mouseY, delta)) || super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public Font getFont() {
        return this.guiObj.getFont();
    }

    @Override
    public int getXSize() {
        return this.f_93618_;
    }

    public void setButtonBackground(ButtonBackground buttonBackground) {
        this.buttonBackground = buttonBackground;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    protected int getButtonX() {
        return this.f_93620_;
    }

    protected int getButtonY() {
        return this.f_93621_;
    }

    protected int getButtonWidth() {
        return this.f_93618_;
    }

    protected int getButtonHeight() {
        return this.f_93619_;
    }

    protected boolean resetColorBeforeRender() {
        return true;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) || GuiUtils.checkChildren(this.children, child -> child.m_5953_(mouseX, mouseY));
    }

    public final boolean isMouseOverCheckWindows(double mouseX, double mouseY) {
        GuiWindow window;
        boolean isHovering = this.m_5953_(mouseX, mouseY);
        if (isHovering && (window = this.guiObj.getWindowHovering(mouseX, mouseY)) != null && !window.childrenContainsElement(e -> e == this)) {
            isHovering = false;
        }
        return isHovering;
    }

    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonBackground != ButtonBackground.NONE) {
            this.drawButton(matrix, mouseX, mouseY);
        }
    }

    public final void onDrawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            this.drawBackground(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public void m_6303_(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    protected int getButtonTextColor(int mouseX, int mouseY) {
        return this.getFGColor();
    }

    protected void drawButtonText(PoseStack matrix, int mouseX, int mouseY) {
        Component text = this.m_6035_();
        if (!text.getString().isEmpty()) {
            int color = this.getButtonTextColor(mouseX, mouseY) | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
            this.drawCenteredTextScaledBound(matrix, text, this.f_93618_ - 4, (float)this.f_93619_ / 2.0f - 4.0f, color);
        }
    }

    protected void drawButton(PoseStack matrix, int mouseX, int mouseY) {
        if (this.resetColorBeforeRender()) {
            MekanismRenderer.resetColor();
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.buttonBackground.getTexture());
        int i = this.m_7202_(this.isMouseOverCheckWindows(mouseX, mouseY));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int width = this.getButtonWidth();
        int height = this.getButtonHeight();
        int halfWidthLeft = width / 2;
        int halfWidthRight = width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = height / 2;
        int halfHeightBottom = height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        int position = i * 20;
        int x = this.getButtonX();
        int y = this.getButtonY();
        GuiElement.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)position, (int)halfWidthLeft, (int)halfHeightTop, (int)200, (int)60);
        GuiElement.m_93133_((PoseStack)matrix, (int)x, (int)(y + halfHeightTop), (float)0.0f, (float)(position + 20 - halfHeightBottom), (int)halfWidthLeft, (int)halfHeightBottom, (int)200, (int)60);
        GuiElement.m_93133_((PoseStack)matrix, (int)(x + halfWidthLeft), (int)y, (float)(200 - halfWidthRight), (float)position, (int)halfWidthRight, (int)halfHeightTop, (int)200, (int)60);
        GuiElement.m_93133_((PoseStack)matrix, (int)(x + halfWidthLeft), (int)(y + halfHeightTop), (float)(200 - halfWidthRight), (float)(position + 20 - halfHeightBottom), (int)halfWidthRight, (int)halfHeightBottom, (int)200, (int)60);
        this.m_7906_(matrix, minecraft, mouseX, mouseY);
        RenderSystem.m_69461_();
        RenderSystem.m_69465_();
    }

    protected void renderExtendedTexture(PoseStack matrix, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderExtendedTexture(matrix, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
    }

    protected void renderBackgroundTexture(PoseStack matrix, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderBackgroundTexture(matrix, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 256, 256);
    }

    public void m_7435_(@NotNull SoundManager soundHandler) {
        if (this.clickSound != null) {
            GuiElement.playClickSound(soundHandler, this.clickSound);
        }
    }

    protected static void playClickSound(SoundEvent sound) {
        GuiElement.playClickSound(minecraft.m_91106_(), sound);
    }

    private static void playClickSound(@NotNull SoundManager soundHandler, @NotNull SoundEvent sound) {
        soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)1.0f));
    }

    protected void drawTiledSprite(PoseStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, GuiUtils.TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(matrix, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, this.m_93252_(), tilingDirection);
    }

    @Override
    public void drawCenteredTextScaledBound(PoseStack matrix, Component text, float maxLength, float x, float y, int color) {
        IFancyFontRenderer.super.drawCenteredTextScaledBound(matrix, text, maxLength, (float)this.relativeX + x, (float)this.relativeY + y, color);
    }

    public static enum ButtonBackground {
        DEFAULT(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button.png")),
        DIGITAL(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button_digital.png")),
        NONE(null);

        private final ResourceLocation texture;

        private ButtonBackground(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    @FunctionalInterface
    public static interface IHoverable {
        public void onHover(GuiElement var1, PoseStack var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface IClickable {
        public boolean onClick(GuiElement var1, int var2, int var3);
    }
}

