/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.INestedRadialMode;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.ScrollIncrementer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.network.to_server.PacketRadialModeChange;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiRadialSelector
extends Screen {
    private static final float DRAWS = 300.0f;
    private static final float INNER = 40.0f;
    private static final float OUTER = 100.0f;
    private static final float MIDDLE_DISTANCE = 70.0f;
    private static final float SELECT_RADIUS = 10.0f;
    private static final float SELECT_RADIUS_WITH_PARENT = 20.0f;
    private final ScrollIncrementer scrollIncrementer = new ScrollIncrementer(true);
    private final Deque<RadialData<?>> parents = new ArrayDeque();
    private final Supplier<Player> playerSupplier;
    private final EquipmentSlot slot;
    @NotNull
    private RadialData<?> radialData;
    private IRadialMode selection = null;
    private boolean overBackButton = false;
    private boolean updateOnClose = true;

    public GuiRadialSelector(EquipmentSlot slot, @NotNull RadialData<?> radialData, Supplier<Player> playerSupplier) {
        super((Component)MekanismLang.RADIAL_SCREEN.translate(new Object[0]));
        this.slot = slot;
        this.radialData = radialData;
        this.playerSupplier = playerSupplier;
    }

    public void m_6305_(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null) {
            float centerX = (float)this.f_96541_.m_91268_().m_85445_() / 2.0f;
            float centerY = (float)this.f_96541_.m_91268_().m_85446_() / 2.0f;
            this.render(matrix, mouseX, mouseY, centerX, centerY, this.radialData);
        }
    }

    private <MODE extends IRadialMode> void render(@NotNull PoseStack matrix, int mouseX, int mouseY, float centerX, float centerY, RadialData<MODE> radialData) {
        List<MODE> modes = radialData.getModes();
        int activeModes = modes.size();
        if (activeModes == 0) {
            RadialData<?> parent = this.parents.pollLast();
            if (parent == null) {
                this.m_7379_();
            } else {
                this.radialData = parent;
            }
            return;
        }
        float angleSize = 360.0f / (float)activeModes;
        matrix.m_85836_();
        matrix.m_85837_((double)centerX, (double)centerY, 0.0);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69472_();
        RenderSystem.m_157429_((float)0.3f, (float)0.3f, (float)0.3f, (float)0.5f);
        this.drawTorus(matrix, 0.0f, 360.0f);
        MODE current = this.getCurrent(radialData);
        if (current == null) {
            current = radialData.getDefaultMode(modes);
        }
        int section = radialData.indexNullable(modes, current);
        if (current != null && section != -1) {
            EnumColor color = current.color();
            if (color == null) {
                RenderSystem.m_157429_((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            } else {
                MekanismRenderer.color(color, 0.3f);
            }
            float startAngle = -90.0f + 360.0f * (-0.5f + (float)section) / (float)activeModes;
            this.drawTorus(matrix, startAngle, angleSize);
        }
        double xDiff = (float)mouseX - centerX;
        double yDiff = (float)mouseY - centerY;
        double distanceFromCenter = Mth.m_184645_((double)xDiff, (double)yDiff);
        float f = this.parents.isEmpty() ? 10.0f : 20.0f;
        if (distanceFromCenter > (double)f) {
            float angle = (float)(57.2957763671875 * Mth.m_14136_((double)yDiff, (double)xDiff));
            float modeSize = 180.0f / (float)activeModes;
            RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
            this.drawTorus(matrix, angle - modeSize, angleSize);
            float selectionAngle = StatUtils.wrapDegrees(angle + modeSize + 90.0f);
            int selectionDrawnPos = (int)(selectionAngle * ((float)activeModes / 360.0f));
            this.selection = (IRadialMode)modes.get(selectionDrawnPos);
            RenderSystem.m_157429_((float)0.6f, (float)0.6f, (float)0.6f, (float)0.7f);
            this.drawTorus(matrix, -90.0f + 360.0f * (-0.5f + (float)selectionDrawnPos) / (float)activeModes, angleSize);
        } else {
            this.selection = null;
        }
        record PositionedText(float x, float y, Component text) {
        }
        ArrayList<PositionedText> textToDraw = new ArrayList<PositionedText>(this.parents.isEmpty() ? activeModes : activeModes + 1);
        if (!this.parents.isEmpty()) {
            boolean bl = this.overBackButton = distanceFromCenter <= 20.0;
            if (this.overBackButton) {
                RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
            } else {
                RenderSystem.m_157429_((float)0.3f, (float)0.3f, (float)0.3f, (float)0.5f);
            }
            this.drawTorus(matrix, 0.0f, 360.0f, 0.0f, 20.0f);
            MekanismRenderer.resetColor();
            RenderSystem.m_69493_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "back.png"));
            GuiRadialSelector.m_93160_((PoseStack)matrix, (int)-12, (int)-18, (int)24, (int)24, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            textToDraw.add(new PositionedText(0.0f, 0.0f, (Component)MekanismLang.BACK.translate(new Object[0])));
        } else {
            this.overBackButton = false;
        }
        MekanismRenderer.resetColor();
        RenderSystem.m_69493_();
        int position = 0;
        for (IRadialMode mode : modes) {
            float degrees = 270.0f + 360.0f * ((float)position++ / (float)activeModes);
            float angle = (float)Math.PI / 180 * degrees;
            float x = Mth.m_14089_((float)angle) * 70.0f;
            float y = Mth.m_14031_((float)angle) * 70.0f;
            RenderSystem.m_157456_((int)0, (ResourceLocation)mode.icon());
            GuiRadialSelector.m_93160_((PoseStack)matrix, (int)Math.round(x - 12.0f), (int)Math.round(y - 20.0f), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            textToDraw.add(new PositionedText(x, y, mode.sliceName()));
        }
        boolean whiteRadialText = MekanismConfig.client.whiteRadialText.get();
        for (PositionedText toDraw : textToDraw) {
            matrix.m_85836_();
            matrix.m_85837_((double)toDraw.x, (double)toDraw.y, 0.0);
            matrix.m_85841_(0.6f, 0.6f, 0.6f);
            Component text = toDraw.text;
            if (whiteRadialText) {
                text = text.m_6881_().m_130940_(ChatFormatting.RESET);
            }
            this.f_96547_.m_92763_(matrix, text, (float)(-this.f_96547_.m_92852_((FormattedText)text)) / 2.0f, 8.0f, -855638017);
            matrix.m_85849_();
        }
        MekanismRenderer.resetColor();
        matrix.m_85849_();
    }

    public void m_7861_() {
        if (this.updateOnClose) {
            this.updateSelection(this.radialData);
        }
        super.m_7861_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return delta != 0.0 && this.mouseScrolled(this.radialData, this.scrollIncrementer.scroll(delta)) || super.m_6050_(mouseX, mouseY, delta);
    }

    private <MODE extends IRadialMode> boolean mouseScrolled(RadialData<MODE> radialData, int shift) {
        MODE current;
        int index;
        if (shift == 0) {
            return true;
        }
        List<MODE> modes = radialData.getModes();
        if (!modes.isEmpty() && (index = radialData.indexNullable(modes, current = this.getCurrent(radialData))) != -1) {
            this.selection = (IRadialMode)MathUtils.getByIndexMod(modes, index + shift);
            this.updateSelection(radialData);
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateSelection(this.radialData);
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawTorus(PoseStack matrix, float startAngle, float sizeAngle) {
        this.drawTorus(matrix, startAngle, sizeAngle, 40.0f, 100.0f);
    }

    private void drawTorus(PoseStack matrix, float startAngle, float sizeAngle, float inner, float outer) {
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tesselator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        float draws = 300.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float degrees = startAngle + (float)i / 300.0f * 360.0f;
            float angle = (float)Math.PI / 180 * degrees;
            float cos = Mth.m_14089_((float)angle);
            float sin = Mth.m_14031_((float)angle);
            vertexBuffer.m_85982_(matrix4f, outer * cos, outer * sin, 0.0f).m_5752_();
            vertexBuffer.m_85982_(matrix4f, inner * cos, inner * sin, 0.0f).m_5752_();
            ++i;
        }
        tesselator.m_85914_();
    }

    @Nullable
    private <MODE extends IRadialMode> MODE getCurrent(RadialData<MODE> radialData) {
        ItemStack stack;
        Item item;
        Player player = this.playerSupplier.get();
        if (player != null && (item = (stack = player.m_6844_(this.slot)).m_41720_()) instanceof IGenericRadialModeItem) {
            IGenericRadialModeItem item2 = (IGenericRadialModeItem)item;
            return item2.getMode(stack, radialData);
        }
        return null;
    }

    private <MODE extends IRadialMode> void updateSelection(RadialData<MODE> radialData) {
        if (this.selection != null && this.playerSupplier.get() != null) {
            INestedRadialMode nested;
            IRadialMode iRadialMode = this.selection;
            if (iRadialMode instanceof INestedRadialMode && (nested = (INestedRadialMode)iRadialMode).hasNestedData()) {
                this.parents.push(radialData);
                this.radialData = nested.nestedData();
                this.selection = null;
            } else if (!this.selection.equals(this.getCurrent(radialData))) {
                int networkRepresentation;
                ArrayList<ResourceLocation> path = new ArrayList<ResourceLocation>(this.parents.size());
                RadialData<?> previousParent = null;
                for (RadialData<?> parent : this.parents) {
                    if (previousParent != null) {
                        path.add(parent.getIdentifier());
                    }
                    previousParent = parent;
                }
                if (previousParent != null) {
                    path.add(radialData.getIdentifier());
                }
                if ((networkRepresentation = radialData.tryGetNetworkRepresentation(this.selection)) != -1) {
                    Mekanism.packetHandler().sendToServer(new PacketRadialModeChange(this.slot, path, networkRepresentation));
                }
            }
        } else if (this.overBackButton) {
            this.overBackButton = false;
            RadialData<?> parent = this.parents.pollLast();
            if (parent != null) {
                this.radialData = parent;
            }
        }
    }

    public boolean hasMatchingData(EquipmentSlot slot, RadialData<?> data) {
        if (this.slot == slot) {
            RadialData<?> firstData = this.parents.peekFirst();
            return firstData == null ? this.radialData.equals(data) : firstData.equals(data);
        }
        return false;
    }

    public void tryInheritCurrentPath(@Nullable Screen screen) {
        if (screen instanceof GuiRadialSelector) {
            INestedRadialMode nestedMode;
            GuiRadialSelector old = (GuiRadialSelector)screen;
            RadialData<?> previousParent = null;
            for (RadialData<?> parent : old.parents) {
                if (previousParent != null && this.radialData.getIdentifier().equals((Object)previousParent.getIdentifier())) {
                    INestedRadialMode nestedMode2 = this.radialData.fromIdentifier(parent.getIdentifier());
                    if (nestedMode2 == null || !nestedMode2.hasNestedData()) {
                        return;
                    }
                    this.parents.push(this.radialData);
                    this.radialData = nestedMode2.nestedData();
                }
                previousParent = parent;
            }
            if (previousParent != null && this.radialData.getIdentifier().equals((Object)previousParent.getIdentifier()) && (nestedMode = this.radialData.fromIdentifier(old.radialData.getIdentifier())) != null && nestedMode.hasNestedData()) {
                this.parents.push(this.radialData);
                this.radialData = nestedMode.nestedData();
                old.updateOnClose = false;
            }
        }
    }

    public boolean shouldHideCrosshair() {
        return !this.parents.isEmpty();
    }
}

