/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import mekanism.client.ClientTickHandler;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.tileentity.RenderSPS;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.network.to_server.PacketKey;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MekanismClient {
    public static final Map<UUID, SecurityData> clientSecurityMap = new Object2ObjectOpenHashMap();
    public static final Map<UUID, String> clientUUIDMap = new Object2ObjectOpenHashMap();
    public static long ticksPassed = 0L;

    private MekanismClient() {
    }

    public static void updateKey(KeyMapping key, int type) {
        MekanismClient.updateKey(key.m_90857_(), type);
    }

    public static void updateKey(boolean pressed, int type) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            boolean down;
            UUID playerUUID = Minecraft.m_91087_().f_91074_.m_20148_();
            boolean bl = down = Minecraft.m_91087_().f_91080_ == null && pressed;
            if (down != Mekanism.keyMap.has(playerUUID, type)) {
                Mekanism.packetHandler().sendToServer(new PacketKey(type, down));
                Mekanism.keyMap.update(playerUUID, type, down);
            }
        }
    }

    public static void reset() {
        clientSecurityMap.clear();
        clientUUIDMap.clear();
        ClientTickHandler.portableTeleports.clear();
        ClientTickHandler.visionEnhancement = false;
        Mekanism.playerState.clear(true);
        Mekanism.activeVibrators.clear();
        RadiationManager.INSTANCE.resetClient();
        SoundHandler.radiationSoundMap.clear();
        RenderSPS.clearBoltRenderers();
        TransmitterNetworkRegistry.getInstance().clearClientNetworks();
        RenderTickHandler.clearQueued();
        MekanismRecipeType.clearCache();
        for (IModModule module : Mekanism.modulesLoaded) {
            module.resetClient();
        }
    }

    public static void launchClient() {
        for (IModModule module : Mekanism.modulesLoaded) {
            module.launchClient();
        }
    }

    @Nullable
    public static Level tryGetClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Nullable
    public static Player tryGetClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

