/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum Upgrade implements IHasTranslationKey
{
    SPEED("speed", APILang.UPGRADE_SPEED, APILang.UPGRADE_SPEED_DESCRIPTION, 8, EnumColor.RED),
    ENERGY("energy", APILang.UPGRADE_ENERGY, APILang.UPGRADE_ENERGY_DESCRIPTION, 8, EnumColor.BRIGHT_GREEN),
    FILTER("filter", APILang.UPGRADE_FILTER, APILang.UPGRADE_FILTER_DESCRIPTION, 1, EnumColor.DARK_AQUA),
    GAS("gas", APILang.UPGRADE_GAS, APILang.UPGRADE_GAS_DESCRIPTION, 8, EnumColor.YELLOW),
    MUFFLING("muffling", APILang.UPGRADE_MUFFLING, APILang.UPGRADE_MUFFLING_DESCRIPTION, 4, EnumColor.INDIGO),
    ANCHOR("anchor", APILang.UPGRADE_ANCHOR, APILang.UPGRADE_ANCHOR_DESCRIPTION, 1, EnumColor.DARK_GREEN),
    STONE_GENERATOR("stone_generator", APILang.UPGRADE_STONE_GENERATOR, APILang.UPGRADE_STONE_GENERATOR_DESCRIPTION, 1, EnumColor.ORANGE);

    private static final Upgrade[] UPGRADES;
    private final String name;
    private final APILang langKey;
    private final APILang descLangKey;
    private final int maxStack;
    private final EnumColor color;

    private Upgrade(String name, APILang langKey, APILang descLangKey, int maxStack, EnumColor color) {
        this.name = name;
        this.langKey = langKey;
        this.descLangKey = descLangKey;
        this.maxStack = maxStack;
        this.color = color;
    }

    public static Map<Upgrade, Integer> buildMap(@Nullable CompoundTag nbtTags) {
        EnumMap<Upgrade, Integer> upgrades = null;
        if (nbtTags != null && nbtTags.m_128425_("upgrades", 9)) {
            ListTag list = nbtTags.m_128437_("upgrades", 10);
            for (int tagCount = 0; tagCount < list.size(); ++tagCount) {
                CompoundTag compound = list.m_128728_(tagCount);
                Upgrade upgrade = Upgrade.byIndexStatic(compound.m_128451_("type"));
                int installed = Mth.m_14045_((int)compound.m_128451_("amount"), (int)0, (int)upgrade.maxStack);
                if (installed <= 0) continue;
                if (upgrades == null) {
                    upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
                }
                upgrades.put(upgrade, installed);
            }
        }
        return upgrades == null ? Collections.emptyMap() : upgrades;
    }

    public static void saveMap(Map<Upgrade, Integer> upgrades, CompoundTag nbtTags) {
        ListTag list = new ListTag();
        for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
            list.add((Object)entry.getKey().getTag(entry.getValue()));
        }
        nbtTags.m_128365_("upgrades", (Tag)list);
    }

    public CompoundTag getTag(int amount) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("type", this.ordinal());
        compound.m_128405_("amount", amount);
        return compound;
    }

    public String getRawName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        return this.langKey.getTranslationKey();
    }

    public Component getDescription() {
        return this.descLangKey.translate(new Object[0]);
    }

    public int getMax() {
        return this.maxStack;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public static Upgrade byIndexStatic(int index) {
        return MathUtils.getByIndexMod(UPGRADES, index);
    }

    static {
        UPGRADES = Upgrade.values();
    }

    public static interface IUpgradeInfoHandler {
        public List<Component> getInfo(Upgrade var1);
    }
}

