/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.mappers.special;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;

public class EnumValueMappers
implements ValueMapper<Enum<?>, JsonPrimitive> {
    private static final Map<Class<? extends Enum<?>>, EnumValueMappers> mappers = new HashMap();
    private final Class<? extends Enum<?>> clazz;

    public static EnumValueMappers getMapper(Class<? extends Enum<?>> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Can't get enum serializer for non-enum class: " + enumClass);
        }
        if (enumClass.getEnumConstants().length == 0) {
            throw new IllegalArgumentException("Can't get enum serializer for empty enum: " + enumClass);
        }
        if (mappers.containsKey(enumClass)) {
            return mappers.get(enumClass);
        }
        EnumValueMappers mapper = new EnumValueMappers(enumClass);
        mappers.put(enumClass, mapper);
        return mapper;
    }

    public EnumValueMappers(Class<? extends Enum<?>> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<Enum<?>> type() {
        return Enum.class;
    }

    @Override
    public Class<JsonPrimitive> element() {
        return JsonPrimitive.class;
    }

    @Override
    public Enum<?> fromJson(JsonPrimitive json) {
        Enum<?>[] enums;
        String str = json.getAsString().toLowerCase(Locale.ROOT).strip();
        for (Enum<?> e : enums = this.clazz.getEnumConstants()) {
            if (!e.name().toLowerCase(Locale.ROOT).equals(str)) continue;
            return e;
        }
        throw new NoSuchElementException("Enum constant not found: " + str);
    }

    @Override
    public JsonPrimitive toJson(Enum<?> value) {
        return new JsonPrimitive(value.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public Enum<?> fromNetwork(FriendlyByteBuf buffer) {
        return this.clazz.getEnumConstants()[buffer.m_130242_()];
    }

    @Override
    public void toNetwork(Enum<?> value, FriendlyByteBuf buffer) {
        buffer.m_130130_(value.ordinal());
    }

    @Override
    public Optional<Enum<?>> correct(JsonElement json, ConfigCorrection<Enum<?>> correction) {
        if (json.isJsonPrimitive() || json.isJsonNull()) {
            Enum<?>[] enums;
            String str = json.isJsonNull() ? "null" : json.getAsString().toLowerCase(Locale.ROOT).strip();
            for (Enum<?> e : enums = this.clazz.getEnumConstants()) {
                if (!e.name().toLowerCase(Locale.ROOT).equals(str) && !str.startsWith(e.name()) && !str.endsWith(e.name())) continue;
                return Optional.of(e);
            }
            try {
                int ordinal = Integer.parseInt(str);
                if (ordinal >= 0 && ordinal < enums.length) {
                    return Optional.of(enums[ordinal]);
                }
                return Optional.empty();
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public List<String> comment() {
        return List.of("Allowed values: " + Arrays.stream(this.clazz.getEnumConstants()).map(e -> e.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", ")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<Enum<?>> createEditor(ValidatorInfo<?> validator) {
        return ConfigEditor.toggle(ImmutableList.copyOf((Object[])this.clazz.getEnumConstants()), e -> Component.m_237113_((String)e.name().toLowerCase(Locale.ROOT)));
    }
}

