/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.datagen.provider.texture.TextureBuilder;
import org.moddingx.libx.datagen.provider.texture.TextureFactory;
import org.moddingx.libx.datagen.provider.texture.Textures;
import org.moddingx.libx.impl.datagen.texture.SignTextureFactory;
import org.moddingx.libx.impl.datagen.texture.TextureGenerator;
import org.moddingx.libx.mod.ModX;

public abstract class TextureProviderBase
implements DataProvider {
    private final ModX mod;
    private final TextureGenerator generator;
    private final Map<ResourceLocation, TextureFactory> textures;

    protected TextureProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        this.mod = mod;
        this.generator = new TextureGenerator(generator, fileHelper);
        this.textures = new HashMap<ResourceLocation, TextureFactory>();
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " textures.";
    }

    public abstract void setup();

    public void texture(String loc, TextureFactory factory) {
        this.texture(this.mod.resource(loc), factory);
    }

    public void image(String loc, TextureFactory factory) {
        this.image(this.mod.resource(loc), factory);
    }

    public void texture(ResourceLocation loc, TextureFactory factory) {
        this.image(new ResourceLocation(loc.m_135827_(), "textures/" + loc.m_135815_() + ".png"), factory);
    }

    public void image(ResourceLocation loc, TextureFactory factory) {
        this.textures.put(loc, factory);
    }

    public void sign(WoodType wood, Block log, Block planks) {
        ResourceLocation logId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)log));
        ResourceLocation planksId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)planks));
        this.sign(wood, new ResourceLocation(logId.m_135827_(), "block/" + logId.m_135815_()), new ResourceLocation(planksId.m_135827_(), "block/" + planksId.m_135815_()));
    }

    public void sign(WoodType wood, ResourceLocation log, ResourceLocation planks) {
        ResourceLocation woodId = new ResourceLocation(wood.m_61846_());
        this.sign(new ResourceLocation(woodId.m_135827_(), "entity/signs/" + woodId.m_135815_()), log, planks);
    }

    public void sign(ResourceLocation signTexture, ResourceLocation log, ResourceLocation planks) {
        this.texture(signTexture, (TextureFactory)new SignTextureFactory(log, planks));
    }

    public void m_213708_(@Nonnull CachedOutput output) throws IOException {
        this.setup();
        for (Map.Entry<ResourceLocation, TextureFactory> entry : this.textures.entrySet()) {
            ResourceLocation id = entry.getKey();
            TextureFactory factory = entry.getValue();
            TextureBuilder builder = new TextureBuilder(this.mod, this.generator::loadImage);
            factory.addTextures(builder);
            Textures textures = builder.build();
            Dimension dim = factory.getSize();
            BufferedImage image = this.generator.newImage(dim.width, dim.height, textures.scale());
            factory.generate(image, textures);
            this.generator.save(output, id, image);
        }
    }
}

