/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.moddingx.libx.annotation.meta.Experimental;
import org.moddingx.libx.datagen.provider.patchouli.page.PageJson;

@Experimental
public class CategoryBuilder {
    public final ResourceLocation id;
    private String name;
    private String description;
    private ItemStack icon;
    private int sort;
    private final List<Consumer<JsonObject>> postProcessors;

    public CategoryBuilder(ResourceLocation id) {
        this.id = id;
        this.sort = -1;
        this.postProcessors = new ArrayList<Consumer<JsonObject>>();
    }

    public CategoryBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CategoryBuilder description(String description) {
        this.description = description;
        return this;
    }

    public CategoryBuilder icon(ItemLike icon) {
        return this.icon(new ItemStack(icon));
    }

    public CategoryBuilder icon(ItemStack icon) {
        this.icon = icon.m_41777_();
        return this;
    }

    public CategoryBuilder sort(int sort) {
        this.sort = sort;
        return this;
    }

    public CategoryBuilder postProcess(Consumer<JsonObject> postProcessor) {
        this.postProcessors.add(postProcessor);
        return this;
    }

    JsonObject build(BiFunction<String, List<String>, String> translations, int num) {
        if (this.name == null) {
            throw new IllegalStateException("Category name not set: " + this.id);
        }
        if (this.description == null) {
            throw new IllegalStateException("Category description not set: " + this.id);
        }
        if (this.icon == null) {
            throw new IllegalStateException("Category icon not set: " + this.id);
        }
        JsonObject json = new JsonObject();
        json.addProperty("name", translations.apply(this.name, List.of("category", this.id.m_135827_(), this.id.m_135815_(), "name")));
        json.addProperty("description", translations.apply(this.description, List.of("category", this.id.m_135827_(), this.id.m_135815_(), "description")));
        json.add("icon", PageJson.stack(this.icon));
        json.addProperty("sortnum", (Number)(this.sort < 0 ? num : this.sort));
        for (Consumer<JsonObject> postProcessor : this.postProcessors) {
            postProcessor.accept(json);
        }
        return json;
    }
}

