/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.compatibility.CompatBase;
import jeresources.entry.AbstractVillagerEntry;
import jeresources.util.VillagersHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VillagerEntry
extends AbstractVillagerEntry<Villager> {
    private final VillagerProfession profession;

    public VillagerEntry(VillagerProfession profession, Int2ObjectMap<VillagerTrades.ItemListing[]> itemListings) {
        super(itemListings);
        this.profession = profession;
    }

    @Override
    public String getName() {
        return this.profession.toString();
    }

    @Override
    public String getDisplayName() {
        return "entity.minecraft.villager." + this.profession.toString();
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    @Override
    public Villager getVillagerEntity() {
        if (this.entity == null) {
            this.entity = (AbstractVillager)EntityType.f_20492_.m_20615_(CompatBase.getLevel());
            assert (this.entity != null);
            ((Villager)this.entity).m_34375_(((Villager)this.entity).m_7141_().m_35565_(this.profession));
        }
        return (Villager)this.entity;
    }

    @Override
    public List<ItemStack> getPois() {
        return VillagersHelper.getPoiBlocks(this.profession.f_219628_()).stream().map(blockstate -> new ItemStack((ItemLike)blockstate.m_60734_())).collect(Collectors.toList());
    }

    @Override
    public boolean hasPois() {
        return !VillagersHelper.getPoiBlocks(this.profession.f_219628_()).isEmpty();
    }

    @Override
    public boolean hasLevels() {
        return true;
    }
}

