/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.ITooltipRenderer;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;

public class TooltipRenderer
implements ITooltipRenderer {
    private final Tooltip tooltip;
    private final boolean showIcon;
    private Vec2 totalSize;
    private IElement icon;
    private float[] padding = new float[]{4.0f, 3.0f, 1.0f, 4.0f};

    public TooltipRenderer(Tooltip tooltip, boolean showIcon) {
        this.showIcon = showIcon;
        this.tooltip = tooltip;
        if (showIcon) {
            this.icon = RayTracing.INSTANCE.getIcon();
        }
        this.recalculateSize();
    }

    @Override
    public float getPadding(int i) {
        return this.padding[i];
    }

    @Override
    public void setPadding(int i, float value) {
        this.padding[i] = value;
    }

    @Override
    public void recalculateSize() {
        float width = 0.0f;
        float height = 0.0f;
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            width = Math.max(width, size.f_82470_);
            height += size.f_82471_;
        }
        float contentHeight = height;
        if (this.hasIcon()) {
            Vec2 size = this.icon.getCachedSize();
            this.padding[3] = this.padding[3] + (size.f_82470_ + 3.0f);
            height = Math.max(height, size.f_82471_);
        }
        this.totalSize = new Vec2(width += this.padding[3] + this.padding[1], height += this.padding[0] + this.padding[2]);
        if (this.hasIcon() && this.icon.getCachedSize().f_82471_ > contentHeight) {
            this.padding[0] = this.padding[0] + (this.icon.getCachedSize().f_82471_ - contentHeight) / 2.0f;
        }
    }

    public void draw(PoseStack matrixStack) {
        IElement icon;
        float x = this.getPadding(3);
        float y = this.getPadding(0);
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            line.render(matrixStack, x, y, this.totalSize.f_82470_ - this.getPadding(1), size.f_82471_);
            y += size.f_82471_;
        }
        if (this.tooltip.sneakyDetails) {
            Minecraft mc = Minecraft.m_91087_();
            x = (this.totalSize.f_82470_ - (float)mc.f_91062_.m_92895_("\u25be") + 1.0f) / 2.0f;
            float yOffset = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f;
            if (yOffset <= 4.0f) {
                y = this.totalSize.f_82471_ - 6.0f + yOffset;
                float alpha = 1.0f - Math.abs(yOffset) / 2.0f;
                int alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
                if (alphaChannel > 4) {
                    mc.f_91062_.m_92883_(matrixStack, "\u25be", x, y, 0xFFFFFF | alphaChannel << 24);
                }
            }
        }
        if ((icon = this.getIcon()) != null) {
            Vec2 size = icon.getCachedSize();
            Vec2 offset = icon.getTranslation();
            float offsetY = offset.f_82471_;
            float min = this.getPadding(0) + this.getPadding(2) + size.f_82471_;
            offsetY = IWailaConfig.get().getOverlay().getIconMode() == IWailaConfig.IconMode.TOP && min < this.totalSize.f_82471_ ? (offsetY += this.getPadding(0)) : (offsetY += (this.totalSize.f_82471_ - size.f_82471_) / 2.0f);
            float offsetX = this.getPadding(3) + offset.f_82470_ - size.f_82470_ - 3.0f;
            Tooltip.drawBorder(matrixStack, offsetX, offsetY, icon);
            icon.render(matrixStack, offsetX, offsetY, offsetX + size.f_82470_, offsetY + size.f_82471_);
        }
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public boolean hasIcon() {
        return this.showIcon && Jade.CONFIG.get().getOverlay().shouldShowIcon() && this.icon != null;
    }

    @Override
    public IElement getIcon() {
        return this.hasIcon() ? this.icon : null;
    }

    @Override
    public void setIcon(IElement icon) {
        this.icon = icon;
    }

    @Override
    public Rect2i getPosition() {
        Window window = Minecraft.m_91087_().m_91268_();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        int x = (int)((float)window.m_85445_() * overlay.tryFlip(overlay.getOverlayPosX()));
        int y = (int)((float)window.m_85446_() * (1.0f - overlay.getOverlayPosY()));
        int width = (int)this.totalSize.f_82470_;
        int height = (int)this.totalSize.f_82471_;
        return new Rect2i(x, y, width, height);
    }

    @Override
    public Vec2 getSize() {
        return this.totalSize;
    }

    @Override
    public void setSize(Vec2 totalSize) {
        this.totalSize = totalSize;
    }
}

