/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import snownee.jade.gui.config.value.OptionValue;

public class InputOptionValue<T>
extends OptionValue<T> {
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?[0-9]+");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)");
    private final EditBox textField;
    private final Predicate<String> validator;

    public InputOptionValue(Runnable responder, String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        super(optionName, setter);
        this.value = value;
        this.validator = validator;
        this.textField = new EditBox(this.client.f_91062_, 0, 0, 98, 18, (Component)Component.m_237113_((String)""));
        this.textField.m_94144_(String.valueOf(value));
        this.textField.m_94151_(s -> {
            if (this.validator.test((String)s)) {
                this.setValue((String)s);
                this.textField.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
            } else {
                this.textField.m_94202_(ChatFormatting.RED.m_126665_().intValue());
            }
            responder.run();
        });
    }

    @Override
    protected void drawValue(PoseStack matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.m_94214_(x);
        this.textField.f_93621_ = y + entryHeight / 6;
        this.textField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public AbstractWidget getListener() {
        return this.textField;
    }

    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            if (this.value instanceof Integer) {
                this.value = Integer.valueOf(text);
            } else if (this.value instanceof Short) {
                this.value = Short.valueOf(text);
            } else if (this.value instanceof Byte) {
                this.value = Byte.valueOf(text);
            } else if (this.value instanceof Long) {
                this.value = Long.valueOf(text);
            } else if (this.value instanceof Double) {
                this.value = Double.valueOf(text);
            } else if (this.value instanceof Float) {
                this.value = Float.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.save();
    }

    @Override
    public void setDisabled(boolean b) {
        super.setDisabled(b);
        this.textField.m_94186_(!b);
    }

    @Override
    public boolean isValidValue() {
        return this.validator.test(this.textField.m_94155_());
    }
}

