/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.utils;

import com.google.common.collect.HashBiMap;
import java.util.Locale;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Material;

public class BlockDeserializationHelper {
    public static final BlockDeserializationHelper INSTANCE = new BlockDeserializationHelper();
    private static final HashBiMap<String, Material> BLOCK_MATERIALS = HashBiMap.create();
    private static final HashBiMap<String, SoundType> SOUND_TYPES = HashBiMap.create();

    private BlockDeserializationHelper() {
    }

    public Material getBlockMaterial(String name) {
        return (Material)BLOCK_MATERIALS.get((Object)name.toLowerCase(Locale.US));
    }

    public String getBlockMaterialName(Material material) {
        return (String)BLOCK_MATERIALS.inverse().get((Object)material);
    }

    public void putBlockMaterial(String name, Material material) {
        BLOCK_MATERIALS.put((Object)name.toLowerCase(Locale.US), (Object)material);
    }

    public SoundType getSoundType(String name) {
        return (SoundType)SOUND_TYPES.get((Object)name.toLowerCase(Locale.US));
    }

    public String getSoundTypeName(SoundType sound) {
        return (String)SOUND_TYPES.inverse().get((Object)sound);
    }

    public void putSoundType(String name, SoundType sound) {
        SOUND_TYPES.put((Object)name.toLowerCase(Locale.US), (Object)sound);
    }

    static {
        INSTANCE.putBlockMaterial("air", Material.f_76296_);
        INSTANCE.putBlockMaterial("structural_air", Material.f_76297_);
        INSTANCE.putBlockMaterial("portal", Material.f_76298_);
        INSTANCE.putBlockMaterial("cloth_decoration", Material.f_76299_);
        INSTANCE.putBlockMaterial("plant", Material.f_76300_);
        INSTANCE.putBlockMaterial("water_plant", Material.f_76301_);
        INSTANCE.putBlockMaterial("replaceable_fireproof_plant", Material.f_76303_);
        INSTANCE.putBlockMaterial("replaceable_water_plant", Material.f_76304_);
        INSTANCE.putBlockMaterial("water", Material.f_76305_);
        INSTANCE.putBlockMaterial("bubble_column", Material.f_76306_);
        INSTANCE.putBlockMaterial("lava", Material.f_76307_);
        INSTANCE.putBlockMaterial("top_snow", Material.f_76308_);
        INSTANCE.putBlockMaterial("fire", Material.f_76309_);
        INSTANCE.putBlockMaterial("decoration", Material.f_76310_);
        INSTANCE.putBlockMaterial("web", Material.f_76311_);
        INSTANCE.putBlockMaterial("sculk", Material.f_164533_);
        INSTANCE.putBlockMaterial("buildable_glass", Material.f_76312_);
        INSTANCE.putBlockMaterial("clay", Material.f_76313_);
        INSTANCE.putBlockMaterial("dirt", Material.f_76314_);
        INSTANCE.putBlockMaterial("grass", Material.f_76315_);
        INSTANCE.putBlockMaterial("ice_solid", Material.f_76316_);
        INSTANCE.putBlockMaterial("sand", Material.f_76317_);
        INSTANCE.putBlockMaterial("sponge", Material.f_76318_);
        INSTANCE.putBlockMaterial("shulker_shell", Material.f_76319_);
        INSTANCE.putBlockMaterial("wood", Material.f_76320_);
        INSTANCE.putBlockMaterial("nether_wood", Material.f_76321_);
        INSTANCE.putBlockMaterial("bamboo_sapling", Material.f_76270_);
        INSTANCE.putBlockMaterial("bamboo", Material.f_76271_);
        INSTANCE.putBlockMaterial("wool", Material.f_76272_);
        INSTANCE.putBlockMaterial("explosive", Material.f_76273_);
        INSTANCE.putBlockMaterial("leaves", Material.f_76274_);
        INSTANCE.putBlockMaterial("glass", Material.f_76275_);
        INSTANCE.putBlockMaterial("ice", Material.f_76276_);
        INSTANCE.putBlockMaterial("cactus", Material.f_76277_);
        INSTANCE.putBlockMaterial("stone", Material.f_76278_);
        INSTANCE.putBlockMaterial("metal", Material.f_76279_);
        INSTANCE.putBlockMaterial("snow", Material.f_76280_);
        INSTANCE.putBlockMaterial("heavy_metal", Material.f_76281_);
        INSTANCE.putBlockMaterial("barrier", Material.f_76282_);
        INSTANCE.putBlockMaterial("piston", Material.f_76283_);
        INSTANCE.putBlockMaterial("moss", Material.f_164530_);
        INSTANCE.putBlockMaterial("vegetable", Material.f_76285_);
        INSTANCE.putBlockMaterial("egg", Material.f_76286_);
        INSTANCE.putBlockMaterial("cake", Material.f_76287_);
        INSTANCE.putBlockMaterial("amethyst", Material.f_164531_);
        INSTANCE.putBlockMaterial("powder_snow", Material.f_164532_);
        INSTANCE.putSoundType("wood", SoundType.f_56736_);
        INSTANCE.putSoundType("gravel", SoundType.f_56739_);
        INSTANCE.putSoundType("grass", SoundType.f_56740_);
        INSTANCE.putSoundType("lily_pad", SoundType.f_56741_);
        INSTANCE.putSoundType("stone", SoundType.f_56742_);
        INSTANCE.putSoundType("metal", SoundType.f_56743_);
        INSTANCE.putSoundType("glass", SoundType.f_56744_);
        INSTANCE.putSoundType("wool", SoundType.f_56745_);
        INSTANCE.putSoundType("sand", SoundType.f_56746_);
        INSTANCE.putSoundType("snow", SoundType.f_56747_);
        INSTANCE.putSoundType("powder_snow", SoundType.f_154681_);
        INSTANCE.putSoundType("ladder", SoundType.f_56748_);
        INSTANCE.putSoundType("anvil", SoundType.f_56749_);
        INSTANCE.putSoundType("slime_block", SoundType.f_56750_);
        INSTANCE.putSoundType("honey_block", SoundType.f_56751_);
        INSTANCE.putSoundType("wet_grass", SoundType.f_56752_);
        INSTANCE.putSoundType("coral_block", SoundType.f_56753_);
        INSTANCE.putSoundType("bamboo", SoundType.f_56754_);
        INSTANCE.putSoundType("bamboo_sapling", SoundType.f_56755_);
        INSTANCE.putSoundType("scaffolding", SoundType.f_56756_);
        INSTANCE.putSoundType("sweet_berry_bush", SoundType.f_56757_);
        INSTANCE.putSoundType("crop", SoundType.f_56758_);
        INSTANCE.putSoundType("hard_crop", SoundType.f_56759_);
        INSTANCE.putSoundType("vine", SoundType.f_56760_);
        INSTANCE.putSoundType("nether_wart", SoundType.f_56761_);
        INSTANCE.putSoundType("lantern", SoundType.f_56762_);
        INSTANCE.putSoundType("stem", SoundType.f_56763_);
        INSTANCE.putSoundType("nylium", SoundType.f_56710_);
        INSTANCE.putSoundType("fungus", SoundType.f_56711_);
        INSTANCE.putSoundType("roots", SoundType.f_56712_);
        INSTANCE.putSoundType("shroomlight", SoundType.f_56713_);
        INSTANCE.putSoundType("weeping_vines", SoundType.f_56714_);
        INSTANCE.putSoundType("twisting_vines", SoundType.f_56715_);
        INSTANCE.putSoundType("soul_sand", SoundType.f_56716_);
        INSTANCE.putSoundType("soul_soil", SoundType.f_56717_);
        INSTANCE.putSoundType("basalt", SoundType.f_56718_);
        INSTANCE.putSoundType("wart_block", SoundType.f_56719_);
        INSTANCE.putSoundType("netherrack", SoundType.f_56720_);
        INSTANCE.putSoundType("nether_bricks", SoundType.f_56721_);
        INSTANCE.putSoundType("nether_sprouts", SoundType.f_56722_);
        INSTANCE.putSoundType("nether_ore", SoundType.f_56723_);
        INSTANCE.putSoundType("bone_block", SoundType.f_56724_);
        INSTANCE.putSoundType("netherite_block", SoundType.f_56725_);
        INSTANCE.putSoundType("ancient_debris", SoundType.f_56726_);
        INSTANCE.putSoundType("lodestone", SoundType.f_56727_);
        INSTANCE.putSoundType("chain", SoundType.f_56728_);
        INSTANCE.putSoundType("nether_gold_ore", SoundType.f_56729_);
        INSTANCE.putSoundType("gilded_blackstone", SoundType.f_56730_);
        INSTANCE.putSoundType("candle", SoundType.f_154653_);
        INSTANCE.putSoundType("amethyst_cluster", SoundType.f_154655_);
        INSTANCE.putSoundType("small_amethyst_bud", SoundType.f_154656_);
        INSTANCE.putSoundType("medium_amethyst_bud", SoundType.f_154657_);
        INSTANCE.putSoundType("large_amethyst_bud", SoundType.f_154658_);
        INSTANCE.putSoundType("tuff", SoundType.f_154659_);
        INSTANCE.putSoundType("calcite", SoundType.f_154660_);
        INSTANCE.putSoundType("dripstone_block", SoundType.f_154661_);
        INSTANCE.putSoundType("pointed_dripstone", SoundType.f_154662_);
        INSTANCE.putSoundType("copper", SoundType.f_154663_);
        INSTANCE.putSoundType("cave_vines", SoundType.f_154664_);
        INSTANCE.putSoundType("spore_blossom", SoundType.f_154665_);
        INSTANCE.putSoundType("azalea", SoundType.f_154666_);
        INSTANCE.putSoundType("flowering_azalea", SoundType.f_154667_);
        INSTANCE.putSoundType("moss_carpet", SoundType.f_154668_);
        INSTANCE.putSoundType("moss", SoundType.f_154669_);
        INSTANCE.putSoundType("big_dripleaf", SoundType.f_154670_);
        INSTANCE.putSoundType("small_dripleaf", SoundType.f_154671_);
        INSTANCE.putSoundType("rooted_dirt", SoundType.f_154672_);
        INSTANCE.putSoundType("hanging_roots", SoundType.f_154673_);
        INSTANCE.putSoundType("azalea_leaves", SoundType.f_154674_);
        INSTANCE.putSoundType("sculk_sensor", SoundType.f_154675_);
        INSTANCE.putSoundType("glow_lichen", SoundType.f_154676_);
        INSTANCE.putSoundType("deepslate", SoundType.f_154677_);
        INSTANCE.putSoundType("deepslate_bricks", SoundType.f_154678_);
        INSTANCE.putSoundType("deepslate_tiles", SoundType.f_154679_);
        INSTANCE.putSoundType("polished_deepslate", SoundType.f_154680_);
    }
}

