/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.ToIntFunction;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.custom.CustomModule;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.JsonHelper;

public class MaterialIntFunctionDeserializer
implements JsonDeserializer<ToIntFunction<IMaterial>> {
    public static final MaterialIntFunctionDeserializer INSTANCE = new MaterialIntFunctionDeserializer();

    private MaterialIntFunctionDeserializer() {
    }

    public ToIntFunction<IMaterial> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "object");
        int defaultValue = helper.getInt(json, "default");
        Object2IntRBTreeMap map = new Object2IntRBTreeMap();
        map.defaultReturnValue(defaultValue);
        if (json.has("materialTypes")) {
            JsonObject materialTypesJson = helper.getJsonObject(json, "materialTypes");
            for (Map.Entry entry : materialTypesJson.entrySet()) {
                int materialTypeValue = helper.getInt((JsonElement)entry.getValue(), "element");
                switch ((String)entry.getKey()) {
                    case "ingot": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isIngot()).forEach(arg_0 -> MaterialIntFunctionDeserializer.lambda$deserialize$1((Object2IntMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "gem": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isGem()).forEach(arg_0 -> MaterialIntFunctionDeserializer.lambda$deserialize$3((Object2IntMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "crystal": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isCrystal()).forEach(arg_0 -> MaterialIntFunctionDeserializer.lambda$deserialize$5((Object2IntMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "dust": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isDust()).forEach(arg_0 -> MaterialIntFunctionDeserializer.lambda$deserialize$7((Object2IntMap)map, materialTypeValue, arg_0));
                    }
                }
            }
        }
        if (json.has("materials")) {
            JsonObject materialsJson = helper.getJsonObject(json, "materials");
            for (Map.Entry entry : materialsJson.entrySet()) {
                if (!MaterialHandler.containsMaterial((String)entry.getKey())) continue;
                map.put((Object)MaterialHandler.getMaterial((String)entry.getKey()), helper.getInt((JsonElement)entry.getValue(), "element"));
            }
        }
        if (json.has("config") && helper.getBoolean(json, "config")) {
            String path = helper.getString(json, "path");
            String comment = json.has("comment") ? helper.getString(json, "comment") : "";
            CustomModule.instance.addCustomConfigDefiner((arg_0, arg_1) -> MaterialIntFunctionDeserializer.lambda$deserialize$8((Object2IntMap)map, path, comment, arg_0, arg_1));
        }
        return map;
    }

    private static /* synthetic */ void lambda$deserialize$8(Object2IntMap map, String path, String comment, IMaterial material, IDynamicSpecConfig config) {
        map.put((Object)material, config.getDefinedInt(path, map.getInt((Object)material), comment));
    }

    private static /* synthetic */ void lambda$deserialize$7(Object2IntMap map, int materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$5(Object2IntMap map, int materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$3(Object2IntMap map, int materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$1(Object2IntMap map, int materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }
}

