/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MeltingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int outputAmount;
    public final Object[] byproducts;
    public final ToIntFunction<FluidStack> temperature;
    public final ToIntFunction<FluidStack> time;

    public MeltingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, Object ... byproducts) {
        this(key, "", input, output, outputAmount, temperature, time, byproducts);
    }

    public MeltingRecipeSerializer(ResourceLocation key, String group, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, Object ... byproducts) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.outputAmount = outputAmount;
        this.byproducts = byproducts;
        this.temperature = temperature;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ArrayList<FluidStack> bys = new ArrayList<FluidStack>();
        int i = 0;
        while (i < this.byproducts.length) {
            Object out = this.byproducts[i];
            Integer amount = 30;
            if (++i < this.byproducts.length && this.byproducts[i] instanceof Integer) {
                amount = (Integer)this.byproducts[i];
                ++i;
            }
            FluidStack by = MiscHelper.INSTANCE.getFluidStack(out, amount);
            if (stack.isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            bys.add(by);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "tconstruct:melting");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        json.add("ingredient", ing.m_43942_());
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeFluidStack(stack));
        if (!bys.isEmpty()) {
            JsonArray byproductsJson = new JsonArray();
            for (FluidStack by : bys) {
                byproductsJson.add((JsonElement)MiscHelper.INSTANCE.serializeFluidStack(by));
            }
            json.add("byproducts", (JsonElement)byproductsJson);
        }
        json.addProperty("temperature", (Number)this.temperature.applyAsInt(stack));
        json.addProperty("time", (Number)this.time.applyAsInt(stack));
        return json;
    }
}

