/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.factorium.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class ExtruderRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object die;
    public final Object output;
    public final int outputCount;

    public ExtruderRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object die, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.die = die;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        Ingredient dieIng = MiscHelper.INSTANCE.getIngredient(this.die);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.die));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "factorium:extruder");
        JsonObject ingJson = MiscHelper.INSTANCE.wrapIngredient(ing).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.inputCount);
        json.add("input", (JsonElement)ingJson);
        json.add("die", dieIng.m_43942_());
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        return json;
    }
}

