/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class MemoizingSupplier<T>
implements Supplier<T> {
    private Supplier<T> delegate;
    private T value;

    private MemoizingSupplier(Supplier<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static <T> MemoizingSupplier<T> of(Supplier<T> delegate) {
        return new MemoizingSupplier<T>(delegate);
    }

    public static <V, T> MemoizingSupplier<T> of(Function<V, T> function, Supplier<V> value) {
        return new MemoizingSupplier<Object>(() -> function.apply(value.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.delegate != null) {
            MemoizingSupplier memoizingSupplier = this;
            synchronized (memoizingSupplier) {
                if (this.delegate != null) {
                    this.value = this.delegate.get();
                    this.delegate = null;
                }
            }
        }
        return this.value;
    }
}

