/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.compat.curios;

import com.blakebr0.ironjetpacks.compat.curios.curio.JetpackCurio;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
    }

    public static Optional<ItemStack> findJetpackCurio(LivingEntity entity) {
        return CuriosCompat.findJetpackCurio(entity, null);
    }

    public static Optional<ItemStack> findJetpackCurio(LivingEntity entity, @Nullable Predicate<SlotResult> predicate) {
        Optional<SlotResult> optional = CuriosApi.getCuriosHelper().findFirstCurio(entity, (Item)ModItems.JETPACK.get());
        if (predicate != null) {
            optional = optional.filter(predicate);
        }
        return optional.map(SlotResult::stack).filter(stack -> JetpackUtils.getJetpack((ItemStack)stack).curios);
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.m_41720_() instanceof JetpackItem) {
            final JetpackCurio curio = new JetpackCurio(stack);
            event.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.capability);
                }
            });
        }
    }
}

