/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.predicate;

import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integratedtunnels.core.TunnelFluidHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;

public class IngredientPredicateFluidStackList
extends IngredientPredicate<FluidStack, Integer> {
    private final boolean blacklist;
    private final IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack> fluidStacks;
    private final boolean checkFluid;
    private final boolean checkAmount;
    private final boolean checkNbt;

    public IngredientPredicateFluidStackList(boolean blacklist, int amount, boolean exactAmount, IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack> fluidStacks, int matchFlags, boolean checkFluid, boolean checkAmount, boolean checkNbt) {
        super(IngredientComponent.FLUIDSTACK, Iterables.transform((Iterable)Iterables.filter(fluidStacks, fluidStack -> !fluidStack.getRawValue().isEmpty()), stack -> TunnelFluidHelpers.prototypeWithCount(stack.getRawValue(), amount)), Integer.valueOf(matchFlags), blacklist, false, amount, exactAmount);
        this.blacklist = blacklist;
        this.fluidStacks = fluidStacks;
        this.checkFluid = checkFluid;
        this.checkAmount = checkAmount;
        this.checkNbt = checkNbt;
    }

    @Override
    public boolean test(@Nullable FluidStack input) {
        for (ValueObjectTypeFluidStack.ValueFluidStack fluidStack : this.fluidStacks) {
            if (fluidStack.getRawValue().isEmpty() || !TunnelFluidHelpers.areFluidStackEqual(input, fluidStack.getRawValue(), this.checkFluid, false, this.checkNbt)) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientPredicateFluidStackList)) {
            return false;
        }
        IngredientPredicateFluidStackList that = (IngredientPredicateFluidStackList)obj;
        return super.equals(obj) && this.blacklist == that.blacklist && this.checkFluid == that.checkFluid && this.checkAmount == that.checkAmount && this.checkNbt == that.checkNbt && this.fluidStacks.equals(that.fluidStacks);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.blacklist ? 1 : 0) << 1 ^ (this.checkFluid ? 1 : 0) << 2 ^ (this.checkAmount ? 1 : 0) << 3 ^ (this.checkNbt ? 1 : 0) << 4 ^ this.fluidStacks.hashCode();
    }
}

