/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerAspectSettings;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;

public abstract class AspectBase<V extends IValue, T extends IValueType<V>>
implements IAspect<V, T> {
    private final IAspectProperties defaultProperties;
    private final ModBase mod;
    private String translationKey = null;

    public AspectBase(ModBase mod, IAspectProperties defaultProperties) {
        this.mod = mod;
        this.defaultProperties = defaultProperties == null ? this.createDefaultProperties() : defaultProperties;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation(this.getModId(), this.getUnlocalizedType().replaceAll("\\.", "_"));
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = this.getUnlocalizedPrefix());
    }

    protected String getUnlocalizedPrefix() {
        return "aspect." + this.getModId() + "." + this.getUnlocalizedType();
    }

    protected abstract String getUnlocalizedType();

    @Override
    public void loadTooltip(List<Component> lines, boolean appendOptionalInfo) {
        MutableComponent aspectName = Component.m_237115_((String)this.getTranslationKey());
        MutableComponent valueTypeName = Component.m_237115_((String)this.getValueType().getTranslationKey());
        lines.add((Component)Component.m_237110_((String)"aspect.integrateddynamics.tooltip.aspect_name", (Object[])new Object[]{aspectName}));
        lines.add((Component)Component.m_237110_((String)"aspect.integrateddynamics.tooltip.value_type_name", (Object[])new Object[]{valueTypeName}).m_130940_(this.getValueType().getDisplayColorFormat()));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean hasProperties() {
        return this.getDefaultProperties() != null;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> IAspectProperties getProperties(P partType, PartTarget target, S state) {
        IAspectProperties properties = state.getAspectProperties(this);
        if (properties == null) {
            properties = this.getDefaultProperties().clone();
            this.setProperties(partType, target, state, properties);
        }
        return properties;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setProperties(P partType, PartTarget target, S state, IAspectProperties properties) {
        state.setAspectProperties(this, properties);
    }

    @Override
    public final IAspectProperties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public Collection<IAspectPropertyTypeInstance> getPropertyTypes() {
        return this.hasProperties() ? this.getDefaultProperties().getTypes() : Collections.emptyList();
    }

    @Override
    public MenuProvider getPropertiesContainerProvider(final PartPos pos) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"gui.integrateddynamics.aspect_settings");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                Triple<IPartContainer, PartTypeBase, PartTarget> data = PartHelpers.getContainerPartConstructionData(pos);
                return new ContainerAspectSettings(id, playerInventory, (Container)new SimpleContainer(0), Optional.of((PartTarget)data.getRight()), Optional.of((IPartContainer)data.getLeft()), Optional.of((IPartType)data.getMiddle()), AspectBase.this);
            }
        };
    }

    @Deprecated
    protected IAspectProperties createDefaultProperties() {
        return null;
    }

    protected ModBase getMod() {
        return this.mod;
    }

    protected String getModId() {
        return this.getMod().getModId();
    }
}

