/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraftforge.common.MinecraftForge;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;

public class PartStateOffsetHandler<P extends IPartType> {
    public final List<InventoryVariableEvaluator<ValueTypeInteger.ValueInteger>> offsetVariableEvaluators = Lists.newArrayList();
    public final Int2ObjectMap<MutableComponent> offsetVariablesSlotMessages = new Int2ObjectArrayMap();
    public boolean offsetVariablesDirty = true;
    public final IntSet offsetVariableSlotDirty = new IntArraySet();
    public final Map<IVariable, Boolean> offsetVariableListeners = new MapMaker().weakKeys().makeMap();

    public void initializeVariableEvaluators(SimpleInventory offsetVariablesInventory) {
        this.offsetVariableEvaluators.clear();
        int i = 0;
        while (i < 3) {
            final int slot = i++;
            this.offsetVariableEvaluators.add(new InventoryVariableEvaluator<ValueTypeInteger.ValueInteger>((Container)offsetVariablesInventory, slot, (IValueType)ValueTypes.INTEGER){

                @Override
                public void onErrorsChanged() {
                    super.onErrorsChanged();
                    PartStateOffsetHandler.this.setOffsetVariableErrors(slot, this.getErrors());
                }
            });
        }
    }

    public void updateOffsetVariables(P partType, IPartState<P> partState, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (this.offsetVariablesDirty) {
            this.offsetVariablesDirty = false;
            this.reloadOffsetVariables(partType, partState, network, partNetwork, target);
        }
        if (!this.offsetVariableSlotDirty.isEmpty()) {
            IntArraySet offsetVariableSlotDirtyCopy = new IntArraySet(this.offsetVariableSlotDirty);
            this.offsetVariableSlotDirty.clear();
            for (Integer slot : offsetVariableSlotDirtyCopy) {
                this.reloadOffsetVariable(partType, partState, network, partNetwork, target, slot);
            }
        }
    }

    public void markOffsetVariablesChanged() {
        this.offsetVariablesDirty = true;
    }

    public SimpleInventory getOffsetVariablesInventory(IPartState<P> partState) {
        SimpleInventory offsetVariablesInventory = new SimpleInventory(3, 1);
        partState.loadInventoryNamed("offsetVariablesInventory", (Container)offsetVariablesInventory);
        return offsetVariablesInventory;
    }

    public void reloadOffsetVariables(P partType, IPartState<P> partState, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        this.offsetVariableSlotDirty.clear();
        SimpleInventory offsetVariablesInventory = this.getOffsetVariablesInventory(partState);
        this.initializeVariableEvaluators(offsetVariablesInventory);
        for (int i = 0; i < offsetVariablesInventory.m_6643_(); ++i) {
            this.reloadOffsetVariable(partType, partState, network, partNetwork, target, i);
        }
    }

    private void setOffsetVariableErrors(int slot, List<MutableComponent> errors) {
        if (errors.isEmpty()) {
            if (this.offsetVariablesSlotMessages.size() > slot) {
                this.offsetVariablesSlotMessages.remove(slot);
            }
        } else {
            this.offsetVariablesSlotMessages.put(slot, (Object)errors.get(0));
        }
    }

    @Nullable
    public MutableComponent getOffsetVariableError(int slot) {
        return (MutableComponent)this.offsetVariablesSlotMessages.get(slot);
    }

    protected void reloadOffsetVariable(P partType, IPartState<P> partState, INetwork network, IPartNetwork partNetwork, PartTarget target, int slot) {
        IVariable<ValueTypeInteger.ValueInteger> variable;
        block14: {
            if (this.offsetVariablesSlotMessages.size() > slot) {
                this.offsetVariablesSlotMessages.remove(slot);
            }
            InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator = this.offsetVariableEvaluators.get(slot);
            evaluator.refreshVariable(network, false);
            variable = evaluator.getVariable(network);
            if (variable != null) {
                try {
                    ValueTypeInteger.ValueInteger value;
                    if (!this.offsetVariableListeners.containsKey(variable)) {
                        variable.addInvalidationListener(() -> {
                            this.offsetVariableListeners.remove(variable);
                            this.offsetVariableSlotDirty.add(slot);
                        });
                        this.offsetVariableListeners.put(variable, true);
                    }
                    if ((value = variable.getValue()).getType() == ValueTypes.INTEGER) {
                        boolean valid;
                        int valueRaw = value.getRawValue();
                        Vec3i offset = partState.getTargetOffset();
                        if (slot == 0) {
                            offset = new Vec3i(valueRaw, offset.m_123342_(), offset.m_123343_());
                        }
                        if (slot == 1) {
                            offset = new Vec3i(offset.m_123341_(), valueRaw, offset.m_123343_());
                        }
                        if (slot == 2) {
                            offset = new Vec3i(offset.m_123341_(), offset.m_123342_(), valueRaw);
                        }
                        if (!(valid = partType.setTargetOffset(partState, target.getCenter(), offset))) {
                            this.offsetVariablesSlotMessages.put(slot, (Object)Component.m_237115_((String)"gui.integrateddynamics.partoffset.slot.message.outofrange"));
                            partState.markDirty();
                        }
                        break block14;
                    }
                    this.offsetVariablesSlotMessages.put(slot, (Object)Component.m_237115_((String)"gui.integrateddynamics.partoffset.slot.message.noint"));
                    partState.markDirty();
                }
                catch (EvaluationException e) {
                    this.offsetVariablesSlotMessages.put(slot, (Object)e.getErrorMessage());
                    partState.markDirty();
                }
            } else if (evaluator.hasVariable()) {
                this.offsetVariableSlotDirty.add(slot);
            }
        }
        try {
            MinecraftForge.EVENT_BUS.post(new PartVariableDrivenVariableContentsUpdatedEvent<P, IPartState<P>>(network, partNetwork, target, partType, partState, null, variable, variable != null ? variable.getValue() : null));
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }
}

