/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.gui.image.Images;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;

public abstract class ContainerScreenMultipart<P extends IPartType<P, S>, S extends IPartState<P>, C extends ContainerMultipart<P, S>>
extends ContainerScreenExtended<C> {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();

    public ContainerScreenMultipart(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        Object partType = ((ContainerMultipart)this.m_6262_()).getPartType();
        if (partType instanceof PartTypeConfigurable && partType.getContainerProviderSettings(null).isPresent()) {
            this.m_142416_((GuiEventListener)new ButtonImage(this.f_97735_ - 20, this.f_97736_ + 0, 18, 18, (Component)Component.m_237115_((String)"gui.integrateddynamics.partsettings"), this.createServerPressable("button_settings", button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_SETTINGS}, false, 0, 0));
            if (((ContainerMultipart)this.m_6262_()).getPartType().supportsOffsets()) {
                this.m_142416_((GuiEventListener)new ButtonImage(this.f_97735_ - 20, this.f_97736_ + 20, 18, 18, (Component)Component.m_237115_((String)"gui.integrateddynamics.part_offsets"), this.createServerPressable("button_offsets", button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_OFFSET}, false, 0, 0));
            }
        }
    }

    protected abstract String getNameId();

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/" + this.getNameId() + ".png");
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.f_96547_.m_92889_(matrixStack, this.m_96636_(), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + 6), 0x404040);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.m_6774_(-20, 0, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.integrateddynamics.part_settings")}), matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.m_6774_(-20, 20, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.integrateddynamics.part_offsets")}), matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }
}

