/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.part;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRendererBase;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;

@OnlyIn(value=Dist.CLIENT)
public class DisplayPartOverlayRenderer
extends PartOverlayRendererBase {
    public static final float MAX = 12.5f;
    protected static final float pixel = 0.0625f;

    @Override
    protected void setMatrixOrientation(PoseStack matrixStack, Direction direction) {
        super.setMatrixOrientation(matrixStack, direction);
        float translateX = -1.0f - (float)direction.m_122429_() + 0.25f;
        float translateY = 1.0f - (float)direction.m_122430_() - 0.25f;
        float translateZ = (float)direction.m_122431_() - 0.0625f + 0.0025f;
        if (direction == Direction.NORTH) {
            translateZ += 1.0f;
        } else if (direction == Direction.EAST) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.SOUTH) {
            translateX += 1.0f;
        } else if (direction == Direction.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.DOWN) {
            translateX += 1.0f;
            translateY -= 1.0f;
        }
        matrixStack.m_85837_((double)translateX, (double)translateY, (double)translateZ);
    }

    @Override
    public void renderPartOverlay(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        BlockPos pos = partContainer.getPosition().getBlockPos();
        if (!this.shouldRender(pos)) {
            return;
        }
        LocalPlayer renderEntity = Minecraft.m_91087_().f_91074_;
        float distanceFactor = (float)(((double)this.getMaxRenderDistance() - renderEntity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) / 5.0);
        float distanceAlpha = Math.min(1.0f, distanceFactor);
        if (distanceAlpha < 0.05f) {
            distanceAlpha = 0.05f;
        }
        matrixStack.m_85836_();
        float scale = 0.04f;
        this.setMatrixOrientation(matrixStack, direction);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        IPartState partStateUnsafe = partContainer.getPartState(direction);
        if (!(partStateUnsafe instanceof PartTypePanelDisplay.State)) {
            this.drawError(context, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
        } else {
            PartTypePanelDisplay.State partState = (PartTypePanelDisplay.State)partStateUnsafe;
            if (partState.getFacingRotation() == null) {
                this.drawError(context, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
                return;
            }
            int rotation = partState.getFacingRotation().ordinal() - 2;
            matrixStack.m_85837_(6.0, 6.0, 0.0);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(rotation * 90)));
            matrixStack.m_85837_(-6.0, -6.0, 0.0);
            IValue value = partState.getDisplayValue();
            if (value != null && partState.isEnabled()) {
                IValueType valueType = value.getType();
                IValueTypeWorldRenderer renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(valueType);
                if (renderer == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                renderer.renderValue(context, partContainer, direction, partType, value, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
            } else if (!partState.getInventory().m_7983_()) {
                this.drawError(context, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
            }
        }
        matrixStack.m_85849_();
    }

    protected void drawError(BlockEntityRendererProvider.Context context, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float distanceAlpha) {
        Images.ERROR.drawWorldWithAlpha(Minecraft.m_91087_().f_90987_, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, 12.5f, 12.5f, distanceAlpha);
    }
}

