/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.blockentity.BlockEntitySqueezer;

public class RenderBlockEntitySqueezer
implements BlockEntityRenderer<BlockEntitySqueezer> {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.0625f;
    private static final float MAXY = 0.115f;
    private static final float MIN = 0.01f;
    private static final float MAX = 0.99f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.0625f, 0.99f}, {0.99f, 0.0625f, 0.99f}, {0.99f, 0.0625f, 0.01f}}, new float[][]{{0.01f, 0.115f, 0.01f}, {0.01f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.01f}}, new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.115f, 0.01f}, {0.99f, 0.115f, 0.01f}, {0.99f, 0.0625f, 0.01f}}, new float[][]{{0.01f, 0.0625f, 0.99f}, {0.01f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.0625f, 0.99f}}, new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.115f, 0.01f}, {0.01f, 0.115f, 0.99f}, {0.01f, 0.0625f, 0.99f}}, new float[][]{{0.99f, 0.0625f, 0.01f}, {0.99f, 0.115f, 0.01f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.0625f, 0.99f}}};

    public RenderBlockEntitySqueezer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntitySqueezer tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            if (!tile.getInventory().m_8020_(0).m_41619_()) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(-0.5, -0.5, -0.5);
                this.renderItem(matrixStack, renderTypeBuffer, tile.getInventory().m_8020_(0), tile);
                matrixStack.m_85849_();
            }
            if (!tile.getTank().isEmpty()) {
                FluidStack fluid = tile.getTank().getFluid();
                int combinedLightCorrected = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_121955_(Direction.UP.m_122436_()));
                RenderHelpers.renderFluidContext((FluidStack)fluid, (PoseStack)matrixStack, () -> {
                    float height = Math.max(0.052500002f, (float)fluid.getAmount() * 0.0625f / 1000.0f + 0.0625f - 0.01f);
                    int brightness = Math.max(combinedLightCorrected, fluid.getFluid().getFluidType().getLightLevel(fluid));
                    int l2 = brightness >> 16 & 0xFFFF;
                    int i3 = brightness & 0xFFFF;
                    for (Direction side : DirectionHelpers.DIRECTIONS) {
                        TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                        Triple color = Helpers.intToRGB((int)renderProperties.getTintColor(fluid));
                        VertexConsumer vb = renderTypeBuffer.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_118414_().m_118330_()));
                        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
                        float[][] c = coordinates[side.ordinal()];
                        float replacedMaxV = side == Direction.UP || side == Direction.DOWN ? icon.m_118412_() : (icon.m_118412_() - icon.m_118411_()) * height + icon.m_118411_();
                        vb.m_85982_(matrix, c[0][0], RenderBlockEntitySqueezer.getHeight(side, c[0][1], height), c[0][2]).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), replacedMaxV).m_7120_(l2, i3).m_5752_();
                        vb.m_85982_(matrix, c[1][0], RenderBlockEntitySqueezer.getHeight(side, c[1][1], height), c[1][2]).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                        vb.m_85982_(matrix, c[2][0], RenderBlockEntitySqueezer.getHeight(side, c[2][1], height), c[2][2]).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                        vb.m_85982_(matrix, c[3][0], RenderBlockEntitySqueezer.getHeight(side, c[3][1], height), c[3][2]).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), replacedMaxV).m_7120_(l2, i3).m_5752_();
                    }
                });
            }
        }
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, ItemStack itemStack, BlockEntitySqueezer tile) {
        matrixStack.m_85836_();
        float yTop = (float)(9 - tile.getItemHeight()) * 0.125f;
        matrixStack.m_85837_(1.0, (double)((yTop - 1.0f) / 2.0f + 1.0f), 1.0);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0);
        if (model.m_7539_()) {
            matrixStack.m_85841_(1.7f, 1.7f, 1.7f);
        }
        matrixStack.m_85841_(1.0f, yTop - 0.125f, 1.0f);
        Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, 0);
        matrixStack.m_85849_();
    }

    private static float getHeight(Direction side, float height, float replaceHeight) {
        if (height == 0.115f) {
            return replaceHeight;
        }
        return height;
    }
}

