/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableCenter;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class VoxelShapeComponentsFactoryHandlerCableConnections
implements VoxelShapeComponentsFactory.IHandler {
    private static final EnumFacingMap<VoxelShape> BOUNDS = EnumFacingMap.forAllValues((Object)Shapes.m_83064_((AABB)new AABB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625)), (Object)Shapes.m_83064_((AABB)new AABB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625)), (Object)Shapes.m_83064_((AABB)new AABB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375)), (Object)Shapes.m_83064_((AABB)new AABB(0.375, 0.625, 0.625, 0.625, 0.375, 1.0)), (Object)Shapes.m_83064_((AABB)new AABB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625)), (Object)Shapes.m_83064_((AABB)new AABB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)));

    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        ArrayList components = Lists.newArrayList();
        if (CableHelpers.isNoFakeCable(world, blockPos, null)) {
            for (Direction direction : Direction.values()) {
                IPartContainer partContainer = null;
                if (!CableHelpers.isCableConnected(world, blockPos, direction) && ((partContainer = (IPartContainer)PartHelpers.getPartContainer(world, blockPos, direction).orElse(null)) == null || !partContainer.hasPart(direction))) continue;
                components.add(new Component(direction, partContainer));
            }
        }
        return components;
    }

    public static class Component
    extends VoxelShapeComponentsFactoryHandlerCableCenter.Component {
        private final Direction direction;
        @Nullable
        private final IPartContainer partContainer;

        public Component(Direction direction, @Nullable IPartContainer partContainer) {
            this.direction = direction;
            this.partContainer = partContainer;
        }

        @Override
        public String getStateId(BlockState blockState, BlockGetter world, BlockPos blockPos) {
            return "conn(" + this.direction.ordinal() + ")";
        }

        @Override
        public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
            if (this.partContainer == null) {
                return (VoxelShape)BOUNDS.get((Object)this.direction);
            }
            IPartType part = this.partContainer.getPart(this.direction);
            if (part == null) {
                return (VoxelShape)BOUNDS.get((Object)this.direction);
            }
            return part.getPartRenderPosition().getSidedCableBoundingBox(this.direction);
        }

        @Override
        public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.m_21120_(hand);
            InteractionResult actionResult = CableHelpers.onCableActivated(world, blockPos, state, player, heldItem, hit.m_82434_(), this.direction);
            if (actionResult.m_19077_()) {
                return actionResult;
            }
            return InteractionResult.PASS;
        }
    }
}

