/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class VoxelShapeComponentsFactoryHandlerCableCenter
implements VoxelShapeComponentsFactory.IHandler {
    private static final VoxelShape BOUNDS = Shapes.m_83064_((AABB)new AABB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625));
    private static final Component COMPONENT = new Component();

    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        if (CableHelpers.isNoFakeCable(world, blockPos, null)) {
            return Collections.singletonList(COMPONENT);
        }
        return Collections.emptyList();
    }

    public static class Component
    implements VoxelShapeComponents.IComponent {
        @Override
        public String getStateId(BlockState blockState, BlockGetter world, BlockPos blockPos) {
            return "cent";
        }

        @Override
        public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
            return BOUNDS;
        }

        @Override
        public ItemStack getCloneItemStack(Level world, BlockPos pos) {
            return new ItemStack((ItemLike)RegistryEntries.BLOCK_CABLE);
        }

        @Override
        public boolean destroy(Level world, BlockPos pos, Player player, boolean saveState) {
            if (!world.m_5776_()) {
                CableHelpers.removeCable(world, pos, player);
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public BakedModel getBreakingBaseModel(Level world, BlockPos pos) {
            return RenderHelpers.getDynamicBakedModel((Level)world, (BlockPos)pos);
        }

        @Override
        public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.m_21120_(hand);
            InteractionResult actionResult = CableHelpers.onCableActivated(world, blockPos, state, player, heldItem, hit.m_82434_(), null);
            if (actionResult.m_19077_()) {
                return actionResult;
            }
            return InteractionResult.PASS;
        }

        @Override
        @Nullable
        public Direction getRaytraceDirection() {
            return null;
        }

        @Override
        public boolean isRaytraceLastForFace() {
            return false;
        }
    }
}

