/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;

public class BlockDryingBasin
extends BlockWithEntityGui {
    private static final VoxelShape SHAPE_RAYTRACE = BlockDryingBasin.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)BlockDryingBasin.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockDryingBasin.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockDryingBasin.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), SHAPE_RAYTRACE}), (BooleanOp)BooleanOp.f_82685_);

    public BlockDryingBasin(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityDryingBasin::new);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockDryingBasin.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_DRYING_BASIN, (BlockEntityTicker)(level.f_46443_ ? new BlockEntityDryingBasin.TickerClient() : new BlockEntityDryingBasin.TickerServer()));
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDryingBasin.class).map(tile -> {
            ItemStack itemStack = player.m_150109_().m_36056_();
            IFluidHandler itemFluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            SingleUseTank tank = tile.getTank();
            ItemStack tileStack = tile.getInventory().m_8020_(0);
            if (itemStack.m_41619_() && !tileStack.m_41619_()) {
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, tileStack);
                tile.getInventory().m_6836_(0, ItemStack.f_41583_);
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            if (player.m_150109_().m_36054_(tileStack)) {
                tile.getInventory().m_6836_(0, ItemStack.f_41583_);
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            if (itemFluidHandler != null && !tank.isFull() && !itemFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                FluidActionResult fluidAction = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (fluidAction.isSuccess()) {
                    ItemStack newItemStack = fluidAction.getResult();
                    InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                    tile.sendUpdate();
                }
                return InteractionResult.SUCCESS;
            }
            if (itemFluidHandler != null && !tank.isEmpty() && itemFluidHandler.fill(tank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
                FluidActionResult fluidAction = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (fluidAction.isSuccess()) {
                    ItemStack newItemStack = fluidAction.getResult();
                    InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.m_41619_() && tileStack.m_41619_()) {
                tile.getInventory().m_6836_(0, itemStack.m_41620_(1));
                if (itemStack.m_41613_() <= 0) {
                    player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                }
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDryingBasin.class).map(tile -> tile.getInventory().m_8020_(0) != null ? 15 : 0).orElse(0);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPE_RAYTRACE;
    }

    public void m_6810_(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDryingBasin.class).ifPresent(tile -> {
                InventoryHelpers.dropItems((Level)world, (Container)tile.getInventory(), (BlockPos)blockPos);
                world.m_46717_(blockPos, oldState.m_60734_());
            });
            super.m_6810_(oldState, world, blockPos, newState, isMoving);
        }
    }
}

