/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate.operator;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public interface IOperator {
    public String getSymbol();

    public ResourceLocation getUniqueName();

    public String getInteractName();

    @Nullable
    public String getGlobalInteractNamePrefix();

    public boolean shouldAlsoPrefixLocalScope();

    default public String getGlobalInteractName() {
        String globalInteractNamePrefix = this.getGlobalInteractNamePrefix() != null ? this.getGlobalInteractNamePrefix() : (this.getInputTypes().length > 0 ? this.getInputTypes()[0].getTypeName() : null);
        return globalInteractNamePrefix != null ? globalInteractNamePrefix + Helpers.capitalizeString(this.getInteractName()) : this.getInteractName();
    }

    default public String getScopedInteractName() {
        return this.shouldAlsoPrefixLocalScope() ? this.getGlobalInteractNamePrefix() + Helpers.capitalizeString(this.getInteractName()) : this.getInteractName();
    }

    public String getTranslationKey();

    public String getUnlocalizedCategoryName();

    public MutableComponent getLocalizedNameFull();

    public void loadTooltip(List<Component> var1, boolean var2);

    public IValueType[] getInputTypes();

    public IValueType getOutputType();

    public IValueType getConditionalOutputType(IVariable[] var1);

    public IValue evaluate(IVariable ... var1) throws EvaluationException;

    public int getRequiredInputLength();

    public MutableComponent validateTypes(IValueType[] var1);

    public IConfigRenderPattern getRenderPattern();

    public IOperator materialize() throws EvaluationException;
}

