/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.client.gui.container.ContainerScreenPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartInterfaceCraftingSettings
extends ContainerScreenPartSettings<ContainerPartInterfaceCraftingSettings>
implements IInputListener {
    private WidgetArrowedListField<IngredientComponent<?, ?>> ingredientComponentSideSelector = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<ContainerScreenPartSettings.SideDropdownEntry> dropdownEntries;
    private IngredientComponent<?, ?> selectedIngredientComponent = null;
    private WidgetNumberField numberFieldChannelInterfaceCrafting = null;
    private ButtonCheckbox checkboxFieldDisabledCraftingCheck = null;
    private ButtonCheckbox checkboxFieldBlockingMode = null;

    public ContainerScreenPartInterfaceCraftingSettings(ContainerPartInterfaceCraftingSettings container, Inventory inventory, Component title) {
        super((ContainerPartSettings)container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedcrafting", "textures/gui/part_interface_settings.png");
    }

    protected boolean isFieldSideEnabled() {
        return false;
    }

    protected int getFieldSideY() {
        return 34;
    }

    protected int getFieldUpdateIntervalY() {
        return 59;
    }

    protected int getFieldPriorityY() {
        return 84;
    }

    protected int getFieldChannelY() {
        return 109;
    }

    protected void onSave() {
        super.onSave();
        try {
            Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : (Direction)this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
            int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getTargetSideOverrideValueId(this.selectedIngredientComponent), (int)side);
            int channelInterface = this.numberFieldChannelInterfaceCrafting.getInt();
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastChannelInterfaceCraftingValueId(), (int)channelInterface);
            ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).setLastDisableCraftingCheckValue(this.checkboxFieldDisabledCraftingCheck.isChecked());
            ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).setLastBlockingModeValue(this.checkboxFieldBlockingMode.isChecked());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.ingredientComponentSideSelector = new WidgetArrowedListField<IngredientComponent<?, ?>>(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + 9, 68, 15, true, (Component)Component.m_237115_((String)"gui.integratedcrafting.partsettings.ingredient"), true, Lists.newArrayList((Iterable)IngredientComponent.REGISTRY.getValues())){

            protected String activeElementToString(IngredientComponent<?, ?> element) {
                return L10NHelpers.localize((String)element.getTranslationKey(), (Object[])new Object[0]);
            }
        };
        this.ingredientComponentSideSelector.setListener((IInputListener)this);
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new ContainerScreenPartSettings.SideDropdownEntry((ContainerScreenPartSettings)this, x$0)).collect(Collectors.toList());
        this.dropdownFieldSide = new WidgetTextFieldDropdown(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + 34, 68, 14, (Component)Component.m_237115_((String)"gui.integrateddynamics.partsettings.side"), true, (Set)Sets.newHashSet(this.dropdownEntries));
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.container).getTargetSideOverrideValue(this.selectedIngredientComponent));
        this.dropdownFieldSide.m_94199_(15);
        this.dropdownFieldSide.m_94194_(true);
        this.dropdownFieldSide.m_94202_(0xFFFFFF);
        this.dropdownFieldSide.m_94190_(true);
        this.numberFieldChannelInterfaceCrafting = new WidgetNumberField(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + 134, 70, 14, true, (Component)Component.m_237115_((String)"gui.integratedcrafting.partsettings.channel.interface"), true);
        this.numberFieldChannelInterfaceCrafting.setPositiveOnly(false);
        this.numberFieldChannelInterfaceCrafting.m_94199_(15);
        this.numberFieldChannelInterfaceCrafting.m_94194_(true);
        this.numberFieldChannelInterfaceCrafting.m_94202_(0xFFFFFF);
        this.numberFieldChannelInterfaceCrafting.m_94190_(true);
        this.checkboxFieldDisabledCraftingCheck = new ButtonCheckbox(this.f_97735_ + 110, this.f_97736_ + 149, 110, 10, (Component)Component.m_237115_((String)"gui.integratedcrafting.partsettings.craftingcheckdisabled"), entry -> {});
        this.checkboxFieldBlockingMode = new ButtonCheckbox(this.f_97735_ + 110, this.f_97736_ + 159, 110, 10, (Component)Component.m_237115_((String)"gui.integratedcrafting.partsettings.blockingmode"), entry -> {});
        this.refreshValues();
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.numberFieldChannelInterfaceCrafting.m_5534_(typedChar, keyCode) && !this.dropdownFieldSide.m_5534_(typedChar, keyCode)) {
            return super.m_5534_(typedChar, keyCode);
        }
        return true;
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.numberFieldChannelInterfaceCrafting.m_7933_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.dropdownFieldSide.m_7933_(typedChar, keyCode, modifiers)) {
                return true;
            }
        }
        return super.m_7933_(typedChar, keyCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.ingredientComponentSideSelector.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.dropdownFieldSide.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.numberFieldChannelInterfaceCrafting.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.checkboxFieldDisabledCraftingCheck.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.checkboxFieldBlockingMode.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + 12), Helpers.RGBToInt((int)0, (int)0, (int)0));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ingredientComponentSideSelector.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.dropdownFieldSide.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.channel.interface", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + 137), 0);
        this.numberFieldChannelInterfaceCrafting.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.craftingcheckdisabled", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + 152), 0);
        this.checkboxFieldDisabledCraftingCheck.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.blockingmode", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + 162), 0);
        this.checkboxFieldBlockingMode.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected int getBaseYSize() {
        return 256;
    }

    protected void setSideInDropdownField(IngredientComponent<?, ?> ingredientComponent, Direction side) {
        if (this.selectedIngredientComponent == ingredientComponent) {
            this.dropdownFieldSide.selectPossibility((IDropdownEntry)this.dropdownEntries.get(side.ordinal()));
        }
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValues()) {
            if (valueId != ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getTargetSideOverrideValueId(ingredientComponent)) continue;
            int side = ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getTargetSideOverrideValue(ingredientComponent).ordinal();
            this.setSideInDropdownField(ingredientComponent, side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastChannelInterfaceCraftingValueId()) {
            this.numberFieldChannelInterfaceCrafting.m_94144_(Integer.toString(((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastChannelInterfaceValue()));
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastDisableCraftingCheckValueId()) {
            this.checkboxFieldDisabledCraftingCheck.setChecked(((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastDisableCraftingCheckValue());
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastBlockingModeValueId()) {
            this.checkboxFieldBlockingMode.setChecked(((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getLastBlockingModeValue());
        }
    }

    public void onChanged() {
        this.onSave();
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.m_6262_()).getTargetSideOverrideValue(this.selectedIngredientComponent));
    }
}

