/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.api.network;

import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.ICraftingInterface;
import org.cyclops.integratedcrafting.api.crafting.UnavailableCraftingInterfacesException;
import org.cyclops.integratedcrafting.api.recipe.IRecipeIndex;

public interface ICraftingNetwork {
    public int[] getChannels();

    public Set<ICraftingInterface> getCraftingInterfaces(int var1);

    public Multimap<IRecipeDefinition, ICraftingInterface> getRecipeCraftingInterfaces(int var1);

    public IRecipeIndex getRecipeIndex(int var1);

    public boolean addCraftingInterface(int var1, ICraftingInterface var2);

    public boolean removeCraftingInterface(int var1, ICraftingInterface var2);

    public boolean addCraftingInterfaceRecipe(int var1, ICraftingInterface var2, IRecipeDefinition var3);

    public boolean removeCraftingInterfaceRecipe(int var1, ICraftingInterface var2, IRecipeDefinition var3);

    public void scheduleCraftingJob(CraftingJob var1, boolean var2) throws UnavailableCraftingInterfacesException;

    public void onCraftingJobFinished(CraftingJob var1);

    public boolean cancelCraftingJob(int var1, int var2);

    public Iterator<CraftingJob> getCraftingJobs(int var1);

    @Nullable
    public CraftingJob getCraftingJob(int var1, int var2);

    public <T, M> Iterator<CraftingJob> getCraftingJobs(int var1, IngredientComponent<T, M> var2, T var3, M var4);

    public CraftingJobDependencyGraph getCraftingJobDependencyGraph();

    @Nullable
    public ICraftingInterface getCraftingJobInterface(int var1, int var2);

    public long getRunningTicks(CraftingJob var1);
}

