/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.util.Color;

public class DeepLearnerItem
extends Item {
    public DeepLearnerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43725_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)ctx.m_43723_()), (MenuProvider)new Provider(ctx.m_43724_()), buf -> buf.writeBoolean(ctx.m_43724_() == InteractionHand.MAIN_HAND));
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (!pPlayer.f_19853_.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)new Provider(pHand), buf -> buf.writeBoolean(pHand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        list.add((Component)Component.m_237110_((String)"hostilenetworks.info.deep_learner", (Object[])new Object[]{Color.withColor("hostilenetworks.color_text.hud", 0xFFFFFF)}).m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96638_()) {
            int i;
            ItemStackHandler inv = DeepLearnerItem.getItemHandler(pStack);
            boolean empty = true;
            for (i = 0; i < 4; ++i) {
                if (inv.getStackInSlot(i).m_41619_()) continue;
                empty = false;
            }
            if (empty) {
                return;
            }
            list.add((Component)Component.m_237115_((String)"hostilenetworks.info.dl_contains").m_130940_(ChatFormatting.GRAY));
            for (i = 0; i < 4; ++i) {
                CachedModel model;
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_() || (model = new CachedModel(stack, 0)).getModel() == null) continue;
                list.add((Component)Component.m_237110_((String)"- %s %s", (Object[])new Object[]{model.getTier().getComponent(), stack.m_41720_().m_7626_(stack)}).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            ItemStackHandler inv = DeepLearnerItem.getItemHandler(pStack);
            boolean empty = true;
            for (int i = 0; i < 4; ++i) {
                if (inv.getStackInSlot(i).m_41619_()) continue;
                empty = false;
            }
            if (empty) {
                return;
            }
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.hold_shift", (Object[])new Object[]{Color.withColor("hostilenetworks.color_text.shift", 0xFFFFFF)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public static ItemStackHandler getItemHandler(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41782_()) {
            return new ItemStackHandler(4);
        }
        ItemStackHandler handler = new ItemStackHandler(4);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("learner_inv")) {
            handler.deserializeNBT(stack.m_41783_().m_128469_("learner_inv"));
        }
        return handler;
    }

    public static void saveItems(ItemStack stack, ItemStackHandler handler) {
        stack.m_41784_().m_128365_("learner_inv", (Tag)handler.serializeNBT());
    }

    protected class Provider
    implements MenuProvider {
        private final InteractionHand hand;

        protected Provider(InteractionHand hand) {
            this.hand = hand;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
            return new DeepLearnerContainer(id, inv, this.hand);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"hostilenetworks.title.deep_learner");
        }
    }
}

