/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.client.DeepLearnerHudRenderer;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.gui.DeepLearnerScreen;
import shadows.hostilenetworks.gui.LootFabScreen;
import shadows.hostilenetworks.gui.SimChamberScreen;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.hostilenetworks.util.ClientEntityCache;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="hostilenetworks")
public class HostileClient {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)Hostile.Containers.DEEP_LEARNER.get()), DeepLearnerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Hostile.Containers.SIM_CHAMBER.get()), SimChamberScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Hostile.Containers.LOOT_FABRICATOR.get()), LootFabScreen::new);
        });
        MinecraftForge.EVENT_BUS.addListener(HostileClient::tick);
    }

    @SubscribeEvent
    public static void mrl(ModelEvent.RegisterAdditional e) {
        e.register(new ResourceLocation("hostilenetworks", "item/data_model_base"));
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> {
            DataModel model = MobPredictionItem.getStoredModel(stack);
            int color = 0xFFFFFF;
            if (model != null) {
                color = model.getNameColor();
            }
            return color;
        }, new ItemLike[]{(ItemLike)Hostile.Items.PREDICTION.get()});
    }

    @SubscribeEvent
    public static void overlays(RegisterGuiOverlaysEvent e) {
        e.registerAboveAll("deep_learner", (IGuiOverlay)new DeepLearnerHudRenderer());
    }

    @SubscribeEvent
    public static void stitch(TextureStitchEvent.Pre e) {
        e.addSprite(new ResourceLocation("hostilenetworks", "item/empty_learner_slot"));
    }

    public static void tick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ClientEntityCache.tick();
        }
    }
}

