/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import terrails.healthoverlay.heart.Heart;
import terrails.healthoverlay.heart.HeartType;
import terrails.healthoverlay.render.RenderUtils;

public class TabHeartRenderer {
    public static TabHeartRenderer INSTANCE = new TabHeartRenderer();
    private final Minecraft client = Minecraft.m_91087_();
    private List<Heart> hearts = Lists.newArrayList();
    private int previousHealth;

    public void renderPlayerListHud(int yPos, int xPos, int xPos2, PlayerInfo playerInfo, PoseStack poseStack, int scoreHealth, long visibilityId) {
        int displayHealth;
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        long currentTime = Util.m_137550_();
        if (visibilityId == playerInfo.m_105347_()) {
            if (scoreHealth < playerInfo.m_105343_()) {
                playerInfo.m_105315_(currentTime);
                playerInfo.m_105328_((long)(this.client.f_91065_.m_93079_() + 20));
            } else if (scoreHealth > playerInfo.m_105343_()) {
                playerInfo.m_105315_(currentTime);
                playerInfo.m_105328_((long)(this.client.f_91065_.m_93079_() + 10));
            }
        }
        playerInfo.m_105333_(visibilityId);
        playerInfo.m_105326_(scoreHealth);
        if (currentTime - playerInfo.m_105345_() > 1000L || visibilityId != playerInfo.m_105347_()) {
            playerInfo.m_105331_(scoreHealth);
            playerInfo.m_105315_(currentTime);
        }
        if (Mth.m_14167_((float)((float)Math.max(scoreHealth, displayHealth = playerInfo.m_105344_()) / 2.0f)) > 0) {
            int healthAmount = Mth.m_14167_((float)Math.max(scoreHealth, displayHealth));
            if (healthAmount != this.previousHealth) {
                this.hearts = RenderUtils.calculateHearts(0, healthAmount, healthAmount, HeartType.NORMAL);
                this.previousHealth = healthAmount;
            }
            long ticks = this.client.f_91065_.m_93079_();
            boolean blinking = playerInfo.m_105346_() > ticks && (playerInfo.m_105346_() - ticks) / 3L % 2L == 1L;
            scoreHealth = Math.min(scoreHealth, 20);
            displayHealth = Math.min(displayHealth, 20);
            int spacingDivisor = Math.max(Mth.m_14167_((float)(scoreHealth / 2)), Math.max(Mth.m_14167_((float)(displayHealth / 2)), 10));
            int spacingMultiplier = Mth.m_14143_((float)Math.min((float)(xPos2 - xPos - 4) / (float)spacingDivisor, 9.0f));
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            RenderSystem.m_69478_();
            for (int i = 0; i < this.hearts.size(); ++i) {
                Heart heart = this.hearts.get(i);
                int xPosition = xPos + i % 10 * spacingMultiplier;
                heart.draw(poseStack, xPosition, yPos, blinking, HeartType.NORMAL);
            }
            RenderSystem.m_69461_();
        }
    }
}

