/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.heart;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public enum HeartType {
    NORMAL(4, 0, true),
    POISONED(8, 2, true),
    WITHERED(12, 4, true),
    FROZEN(18, 6, false);

    private final int indexVanilla;
    private final int index;
    private final boolean canBlink;

    private HeartType(int indexVanilla, int index, boolean canBlink) {
        this.indexVanilla = indexVanilla;
        this.index = index;
        this.canBlink = canBlink;
    }

    public int getX(int x, boolean vanilla, boolean absorption, boolean blinking) {
        if (vanilla) {
            x += 16;
            if (absorption) {
                x += 144;
            } else {
                x += this.indexVanilla * 9;
                if (this.canBlink && blinking) {
                    x += 18;
                }
            }
        } else {
            x += this.index * 9;
        }
        return x;
    }

    public static HeartType forPlayer(Player player) {
        if (player.m_21023_(MobEffects.f_19614_)) {
            return POISONED;
        }
        if (player.m_21023_(MobEffects.f_19615_)) {
            return WITHERED;
        }
        if (player.m_146890_()) {
            return FROZEN;
        }
        return NORMAL;
    }
}

