/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config.screen.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import terrails.healthoverlay.heart.HeartPiece;
import terrails.healthoverlay.heart.HeartType;

public class HeartColorEditBox
extends EditBox {
    private boolean validHex;
    private boolean health;
    private final HeartType type;
    private static final Pattern HEX_PATTERN = Pattern.compile("^#[0-9a-fA-F]{6}$");

    public HeartColorEditBox(Font font, int x, int y, int width, int height, Component component, HeartType type, boolean health) {
        this(font, x, y, width, height, null, component, type, health);
    }

    public HeartColorEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component component, HeartType type, boolean health) {
        super(font, x, y, width, height, editBox, component);
        this.type = type;
        this.health = health;
        Pattern filterPattern = Pattern.compile("^#[0-9A-F]*$", 2);
        this.m_94151_(str -> {});
        this.m_94153_(str -> filterPattern.matcher((CharSequence)str).matches());
        this.m_94199_(7);
        if (editBox != null) {
            this.m_94144_(editBox.m_94155_());
        }
    }

    public boolean isValidHex() {
        return this.validHex;
    }

    public HeartPiece getHeartPiece() {
        return HeartPiece.custom(this.m_94155_(), !this.health);
    }

    public void m_94151_(@NotNull Consumer<String> responder) {
        super.m_94151_(str -> {
            this.validHex = HEX_PATTERN.matcher((CharSequence)str).matches();
            responder.accept((String)str);
        });
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
        if (!this.m_94213_()) {
            return;
        }
        if (!this.isValidHex()) {
            boolean isBordered;
            boolean bl = isBordered = this.m_94210_() < this.f_93618_;
            if (isBordered) {
                int borderColor = this.m_93696_() ? -2743526 : -10942713;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)this.f_93621_, (int)borderColor);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ + this.f_93619_), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)borderColor);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)this.f_93621_, (int)this.f_93620_, (int)(this.f_93621_ + this.f_93619_), (int)borderColor);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ + this.f_93618_), (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_), (int)borderColor);
            }
        } else {
            HeartPiece heart = this.getHeartPiece();
            heart.draw(poseStack, this.f_93620_ + this.f_93618_ - 11, this.f_93621_ + this.f_93619_ / 2 - 4, false, false, this.type);
        }
    }
}

