/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.data.ContainerType;
import xfacthd.framedblocks.api.data.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.common.FBContent;

public class FluidCamoContainer
extends CamoContainer {
    private final FluidState fluidState;

    private FluidCamoContainer(FluidState fluidState) {
        super((BlockState)fluidState.m_76188_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(8)));
        this.fluidState = fluidState;
    }

    @Override
    public int getColor(BlockAndTintGetter level, BlockPos pos, int tintIdx) {
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getFluidColor(level, pos, this.fluidState);
        }
        throw new UnsupportedOperationException("Block color is not available on the server!");
    }

    @Override
    public ItemStack toItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        return cap.map(handler -> {
            FluidStack fluid = new FluidStack(this.fluidState.m_76152_(), 1000);
            if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer();
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    public Fluid getFluid() {
        return this.fluidState.m_76152_();
    }

    @Override
    public boolean canRotateCamo() {
        return false;
    }

    @Override
    public boolean rotateCamo() {
        return false;
    }

    @Override
    public SoundType getSoundType() {
        return super.getSoundType();
    }

    @Override
    public ContainerType getType() {
        return ContainerType.FLUID;
    }

    @Override
    public CamoContainer.Factory getFactory() {
        return (CamoContainer.Factory)FBContent.factoryFluid.get();
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128365_("fluid", (Tag)NbtUtils.m_178022_((FluidState)this.fluidState));
    }

    public static final class Factory
    extends CamoContainer.Factory {
        @Override
        public CamoContainer fromNbt(CompoundTag tag) {
            FluidState fluidState = Utils.readFluidStateFromNbt(tag.m_128469_("fluid"));
            return new FluidCamoContainer(fluidState);
        }

        @Override
        public CamoContainer fromItem(ItemStack stack) {
            LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            return cap.map(handler -> {
                FluidStack fluid = handler.getFluidInTank(0);
                FluidState state = fluid.getFluid().m_76145_();
                if (!state.m_76178_()) {
                    int amount = 1000;
                    if (fluid.getAmount() >= amount && handler.drain(amount, IFluidHandler.FluidAction.SIMULATE).getAmount() == amount) {
                        return new FluidCamoContainer(state);
                    }
                }
                return EmptyCamoContainer.EMPTY;
            }).orElse(EmptyCamoContainer.EMPTY);
        }
    }
}

