/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.create;

import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.behaviour.TrapdoorMovingInteraction;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.utility.NBTProcessors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.create.FramedBlockMovementChecks;

public final class CreateCompat {
    private static boolean loadedClient = false;

    public static void init() {
        if (ModList.get().isLoaded("create")) {
            try {
                if (FMLEnvironment.dist.isClient()) {
                    GuardedClientAccess.init();
                    loadedClient = true;
                }
            }
            catch (Throwable e) {
                FramedBlocks.LOGGER.warn("An error occured while initializing client-only Create integration!", e);
            }
        }
    }

    public static void commonSetup() {
        if (ModList.get().isLoaded("create")) {
            try {
                GuardedAccess.init();
            }
            catch (Throwable e) {
                FramedBlocks.LOGGER.warn("An error occured while initializing Create integration!", e);
            }
        }
    }

    public static Object tryGetCTContext(ModelData data) {
        if (loadedClient) {
            return GuardedClientAccess.tryGetCTContext(data);
        }
        return null;
    }

    private CreateCompat() {
    }

    private static final class GuardedClientAccess {
        private static ModelProperty<?> CREATE_CT_PROPERTY;

        private GuardedClientAccess() {
        }

        public static void init() {
            CREATE_CT_PROPERTY = (ModelProperty)ObfuscationReflectionHelper.getPrivateValue(CTModel.class, null, (String)"CT_PROPERTY");
        }

        public static Object tryGetCTContext(ModelData data) {
            return data.get(CREATE_CT_PROPERTY);
        }
    }

    private static final class GuardedAccess {
        private GuardedAccess() {
        }

        public static void init() {
            GuardedAccess.registerInteractionBehaviour(FBContent.blockFramedLever, (MovingInteractionBehaviour)new LeverMovingInteraction());
            GuardedAccess.registerInteractionBehaviour(FBContent.blockFramedDoor, (MovingInteractionBehaviour)new DoorMovingInteraction());
            GuardedAccess.registerInteractionBehaviour(FBContent.blockFramedTrapDoor, (MovingInteractionBehaviour)new TrapdoorMovingInteraction());
            BlockMovementChecks.registerAllChecks((BlockMovementChecks.AllChecks)new FramedBlockMovementChecks());
            NBTProcessors.addProcessor((BlockEntityType)((BlockEntityType)FBContent.blockEntityTypeFramedSign.get()), tag -> {
                for (int i = 0; i < 4; ++i) {
                    String key = "Text" + (i + 1);
                    if (!NBTProcessors.textComponentHasClickEvent((String)tag.m_128461_(key))) continue;
                    tag.m_128473_(key);
                }
                return tag;
            });
        }

        private static void registerInteractionBehaviour(RegistryObject<Block> block, MovingInteractionBehaviour behaviour) {
            AllInteractionBehaviours.registerBehaviour((Block)((Block)block.get()), (MovingInteractionBehaviour)behaviour);
        }
    }
}

