/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.FramedWaterloggableWeightedPressurePlateBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWeightedPressurePlateBlock
extends WeightedPressurePlateBlock
implements IFramedBlock {
    private static final Map<BlockType, BlockType> WATERLOGGING_SWITCH = Map.of(BlockType.FRAMED_GOLD_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE, BlockType.FRAMED_GOLD_PRESSURE_PLATE, BlockType.FRAMED_IRON_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE, BlockType.FRAMED_IRON_PRESSURE_PLATE);
    private final BlockType type;

    protected FramedWeightedPressurePlateBlock(BlockType type, int maxWeight, BlockBehaviour.Properties props) {
        super(maxWeight, props);
        this.type = type;
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_150930_((Item)FBContent.itemFramedHammer.get())) {
            if (!level.m_5776_()) {
                Utils.wrapInStateCopy((LevelAccessor)level, pos, player, ItemStack.f_41583_, false, false, () -> {
                    BlockState newState = this.getCounterpart().m_49966_();
                    level.m_46597_(pos, newState);
                });
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    protected final Block getCounterpart() {
        return FBContent.byType(WATERLOGGING_SWITCH.get(this.type));
    }

    public static BlockState mergeWeightedState(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if ((Integer)state.m_61143_((Property)WeightedPressurePlateBlock.f_58198_) > 1) {
            return (BlockState)state.m_61124_((Property)WeightedPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(1));
        }
        return state;
    }

    public static FramedWeightedPressurePlateBlock gold() {
        return new FramedWeightedPressurePlateBlock(BlockType.FRAMED_GOLD_PRESSURE_PLATE, 15, IFramedBlock.createProperties(BlockType.FRAMED_GOLD_PRESSURE_PLATE).m_60910_().m_60978_(0.5f));
    }

    public static FramedWeightedPressurePlateBlock goldWaterloggable() {
        return new FramedWaterloggableWeightedPressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE, 15, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE).m_60910_().m_60978_(0.5f));
    }

    public static FramedWeightedPressurePlateBlock iron() {
        return new FramedWeightedPressurePlateBlock(BlockType.FRAMED_IRON_PRESSURE_PLATE, 150, IFramedBlock.createProperties(BlockType.FRAMED_IRON_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f));
    }

    public static FramedWeightedPressurePlateBlock ironWaterloggable() {
        return new FramedWaterloggableWeightedPressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE, 150, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f));
    }
}

