/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction.Axis axis;
    private final boolean ySlope;

    public FramedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean quadOnFacingAxis;
        Direction quadFace = quad.m_111306_();
        if (this.isStateInvalid()) {
            quadMap.get(quadFace).add(quad);
            return;
        }
        boolean yFacing = Utils.isY(this.facing);
        boolean yAxis = this.axis == Direction.Axis.Y;
        boolean quadOnAxis = quadFace.m_122434_() == this.axis;
        boolean bl = quadOnFacingAxis = quadFace.m_122434_() == this.facing.m_122434_();
        if (!this.ySlope && yFacing && !quadOnAxis && !quadOnFacingAxis) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!up, 0.5f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && yFacing && Utils.isY(quadFace)) {
            Direction onAxis = Direction.m_122387_((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction offAxisCW = onAxis.m_122427_();
            Direction offAxisCCW = onAxis.m_122428_();
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(offAxisCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCCW, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(offAxisCCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCW, 45.0f)).export(quadMap.get(null));
        } else if (!yFacing && yAxis && !quadOnAxis && !quadOnFacingAxis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.m_122428_(), 45.0f)).export(quadMap.get(null));
        } else if (!(this.ySlope || yFacing || yAxis || quadFace != this.facing)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && !yFacing && !yAxis && Utils.isY(quadFace)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        } else if (quadFace.m_122434_() == this.axis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing)).export(quadMap.get(quadFace));
        }
    }

    private boolean isStateInvalid() {
        return this.axis == this.facing.m_122434_();
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemTransforms.TransformType type) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP);
    }
}

