/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.compat.rubidium.RubidiumCompat;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlockModel
extends FramedBlockModel {
    private static final float MIN_DEPTH = 0.001f;
    private final Direction collapsedFace;
    private final boolean rotSplitLine;

    public FramedCollapsibleBlockModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.collapsedFace = ((NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE))).toDirection();
        this.rotSplitLine = (Boolean)state.m_61143_((Property)PropertyHolder.ROTATE_SPLIT_LINE) ^ RubidiumCompat.invertCollapsibleBlockSplitLineRotation();
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, ModelData data) {
        Direction quadDir = quad.m_111306_();
        if (this.collapsedFace == null || quadDir == this.collapsedFace.m_122424_()) {
            quadMap.get(quadDir).add(quad);
            return;
        }
        Integer offsets = (Integer)data.get(FramedCollapsibleBlockEntity.OFFSETS);
        float[] vertexPos = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (offsets != null && offsets != 0) {
            byte[] relOff = FramedCollapsibleBlockEntity.unpackOffsets(offsets);
            boolean allSame = relOff[0] == relOff[1] && relOff[0] == relOff[2] && relOff[0] == relOff[3];
            for (int i = 0; i < 4; ++i) {
                vertexPos[i] = Math.max(1.0f - (float)relOff[i] / 16.0f, allSame ? 0.001f : 0.0f);
            }
        }
        if (quadDir == this.collapsedFace) {
            float diff02 = Math.abs(vertexPos[0] - vertexPos[2]);
            float diff13 = Math.abs(vertexPos[1] - vertexPos[3]);
            boolean rotate = diff13 > diff02 != this.rotSplitLine;
            QuadModifier.geometry(quad).apply(Modifiers.setPosition(vertexPos, true)).applyIf(Modifiers.rotateVertices(), rotate).export(quadMap.get(null));
        } else if (Utils.isY(this.collapsedFace)) {
            boolean top = this.collapsedFace == Direction.UP;
            int idxOne = this.getYCollapsedIndexOffset(quadDir);
            int idxTwo = Math.floorMod(idxOne + (top ? 1 : -1), 4);
            float posOne = vertexPos[idxOne];
            float posTwo = vertexPos[idxTwo];
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!top, posOne, posTwo)).export(quadMap.get(quadDir));
        } else if (Utils.isY(quadDir)) {
            boolean top = quad.m_111306_() == Direction.UP;
            float posOne = vertexPos[top ? 0 : 1];
            float posTwo = vertexPos[top ? 3 : 2];
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.collapsedFace, posOne, posTwo)).export(quadMap.get(quadDir));
        } else {
            boolean right = this.collapsedFace == quadDir.m_122427_();
            float posTop = vertexPos[right ? 3 : 0];
            float posBot = vertexPos[right ? 2 : 1];
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.collapsedFace, posTop, posBot)).export(quadMap.get(quadDir));
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
    }

    @Override
    protected boolean useBaseModel() {
        return true;
    }

    @Override
    protected FramedBlockModel.QuadCacheKey makeCacheKey(BlockState state, Object ctCtx, ModelData data) {
        Integer packedOffsets = (Integer)data.get(FramedCollapsibleBlockEntity.OFFSETS);
        return new CollapsibleBlockQuadCacheKey(state, ctCtx, packedOffsets);
    }

    private int getYCollapsedIndexOffset(Direction quadFace) {
        boolean top = this.collapsedFace == Direction.UP;
        return switch (quadFace) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> {
                if (top) {
                    yield 3;
                }
                yield 2;
            }
            case Direction.EAST -> {
                if (top) {
                    yield 2;
                }
                yield 3;
            }
            case Direction.SOUTH -> {
                if (top) {
                    yield 1;
                }
                yield 0;
            }
            case Direction.WEST -> {
                if (top) {
                    yield 0;
                }
                yield 1;
            }
            case Direction.DOWN, Direction.UP -> throw new IllegalArgumentException("Invalid facing for y face collapse!");
        };
    }

    private record CollapsibleBlockQuadCacheKey(BlockState state, Object ctCtx, Integer packedOffsets) implements FramedBlockModel.QuadCacheKey
    {
    }
}

