/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.init;

import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.data.LeafSettingGenerator;
import de.cheaterpaul.fallingleaves.data.LeafSettingLoader;
import de.cheaterpaul.fallingleaves.data.LeafTypeLoader;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.modcompat.SereneSeasons;
import de.cheaterpaul.fallingleaves.util.TextureCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientMod {
    public static final ResourceLocation DEFAULT = new ResourceLocation("fallingleaves", "default");
    public static final ResourceLocation CONIFER = new ResourceLocation("fallingleaves", "conifer");
    private static LeafTypeLoader leafTypeLoader;
    private static LeafSettingLoader treeValueLoader;

    public static SpriteSet getSpriteForLeafType(ResourceLocation leafType) {
        return leafTypeLoader.getSpriteSet(leafType);
    }

    public static LeafSettingsEntry getLeafSetting(ResourceLocation location) {
        return treeValueLoader.getLeafSetting(location);
    }

    private static void gatherData(GatherDataEvent event) {
        if (event.includeClient()) {
            event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new LeafSettingGenerator(event.getGenerator()));
        }
    }

    public static void setupClient() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientMod::gatherData);
        bus.addListener(ClientMod::registerReloadListeners);
        bus.addListener(ClientMod::registerReloadListeners);
        bus.addListener(ClientMod::onReload);
        if (SereneSeasons.setup()) {
            bus.register(SereneSeasons.class);
        }
        FallingLeavesConfig.registerConfigs();
    }

    public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        leafTypeLoader = new LeafTypeLoader(Minecraft.m_91087_().m_91097_());
        event.registerReloadListener((PreparableReloadListener)leafTypeLoader);
        treeValueLoader = new LeafSettingLoader();
        event.registerReloadListener((PreparableReloadListener)treeValueLoader);
    }

    public static void onReload(TextureStitchEvent.Post event) {
        TextureCache.INST.clear();
    }
}

