/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.capability.AbilityStoreCapabilityProvider;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.network.packet.SendAbilityStorePacket;

public class RequestAbilityStorePacket
extends PacketCodec {
    @CodecField
    private String entityUuid;

    public RequestAbilityStorePacket() {
    }

    public RequestAbilityStorePacket(String entityUuid) {
        this.entityUuid = entityUuid;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level world, Player player) {
    }

    public void actionServer(net.minecraft.world.level.Level world, ServerPlayer player) {
        try {
            UUID uuid = UUID.fromString(this.entityUuid);
            Entity entity = ((ServerLevel)world).m_8791_(uuid);
            if (entity != null) {
                entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(abilityStore -> {
                    Tag contents = AbilityStoreCapabilityProvider.serializeNBTStatic(AbilityHelpers.getRegistry(world.m_5962_()), abilityStore);
                    CompoundTag tag = new CompoundTag();
                    tag.m_128365_("contents", contents);
                    EverlastingAbilities._instance.getPacketHandler().sendToPlayer((PacketBase)new SendAbilityStorePacket(entity.m_19879_(), tag), player);
                });
            }
        }
        catch (IllegalArgumentException e) {
            EverlastingAbilities.clog(Level.ERROR, e.getMessage());
        }
    }
}

