/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeSpecialPowerStare
extends AbilityTypeAdapter {
    private static final int TICK_MODULUS = 5;
    private final boolean requireSneak;

    public AbilityTypeSpecialPowerStare(ICondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, boolean requireSneak) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.requireSneak = requireSneak;
    }

    @Override
    public Codec<? extends IAbilityType> codec() {
        return Objects.requireNonNull(RegistryEntries.ABILITYSERIALIZER_SPECIAL_POWER_STARE);
    }

    public boolean isRequireSneak() {
        return this.requireSneak;
    }

    @Override
    public void onTick(Player player, int level) {
        if (this.isRequireSneak() && !player.m_6047_()) {
            return;
        }
        Level world = player.f_19853_;
        if (!world.f_46443_ && player.f_19853_.m_46467_() % 5L == 0L) {
            int range = level * 10;
            double eyeHeight = player.m_20192_();
            Vec3 lookVec = player.m_20154_();
            Vec3 origin = new Vec3(player.m_20185_(), player.m_20186_() + eyeHeight, player.m_20189_());
            Vec3 direction = origin.m_82520_(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
            List list = world.m_45933_((Entity)player, player.m_20191_().m_82363_(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range).m_82400_((double)range));
            for (Entity e : list) {
                double distance;
                if (!e.m_6087_() || e instanceof TamableAnimal && ((TamableAnimal)e).m_21826_() == player || player.m_7307_(e)) continue;
                Entity entity = null;
                float f10 = e.m_6143_();
                AABB axisalignedbb = e.m_20191_().m_82363_((double)f10, (double)f10, (double)f10);
                Vec3 hitVec = axisalignedbb.m_82371_(origin, direction).orElse(null);
                if (axisalignedbb.m_82390_(origin)) {
                    entity = e;
                } else if (hitVec != null && ((distance = origin.m_82554_(hitVec)) < (double)range || (double)range == 0.0)) {
                    if (e == player.m_20202_() && !player.canRiderInteract()) {
                        if ((double)range == 0.0) {
                            entity = e;
                        }
                    } else {
                        entity = e;
                    }
                }
                if (entity == null) continue;
                double dx = entity.m_20185_() - player.m_20185_();
                double dy = entity.m_20186_() - player.m_20186_();
                double dz = entity.m_20189_() - player.m_20189_();
                double d = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
                double m = 1.0 / (2.0 * Math.max(1.0, d));
                double strength = 3.0;
                entity.m_20334_((dx *= m) * strength, (dy *= m) * strength, (dz *= m) * strength);
                break;
            }
        }
    }
}

