/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.energeticsheep.capability.energystorage.EnergyStorageItem;
import org.cyclops.energeticsheep.item.ItemEnergeticShearsConfig;

public class ItemEnergeticShears
extends ShearsItem {
    public ItemEnergeticShears(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(itemStack, worldIn, tooltip, flagIn);
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        if (energyStorage != null) {
            int amount = energyStorage.getEnergyStored();
            int capacity = energyStorage.getMaxEnergyStored();
            String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + L10NHelpers.localize((String)"general.energeticsheep.energy_unit", (Object[])new Object[0]);
            tooltip.add((Component)Component.m_237113_((String)line).m_130940_(IInformationProvider.ITEM_PREFIX));
        }
    }

    public static InteractionResult transferEnergy(Player player, BlockPos pos, Direction side, InteractionHand hand) {
        Level worldIn = player.f_19853_;
        if (!player.m_6047_()) {
            return BlockEntityHelpers.getCapability((BlockGetter)worldIn, (BlockPos)pos, (Direction)side, (Capability)CapabilityEnergy.ENERGY).map(energyTarget -> {
                ItemStack itemStack = player.m_21120_(hand);
                return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyItem -> energyTarget.receiveEnergy(energyItem.extractEnergy(energyTarget.receiveEnergy(energyItem.extractEnergy(ItemEnergeticShearsConfig.usageTransferAmount, true), true), worldIn.f_46443_), worldIn.f_46443_) > 0 ? InteractionResult.SUCCESS : InteractionResult.FAIL).orElse(null);
            }).orElse(null);
        }
        return null;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        InteractionResult result = ItemEnergeticShears.transferEnergy(context.m_43723_(), context.m_8083_(), context.m_43719_(), context.m_43724_());
        if (result == null) {
            return super.onItemUseFirst(stack, context);
        }
        return result;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    @Nullable
    protected IEnergyStorage getEnergyStorage(ItemStack itemStack) {
        if (CapabilityEnergy.ENERGY == null) {
            return null;
        }
        return (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
    }

    protected boolean canShear(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        return energyStorage != null && energyStorage.getEnergyStored() > ItemEnergeticShearsConfig.shearConsumption;
    }

    protected void consumeOnShear(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        if (energyStorage != null) {
            energyStorage.extractEnergy(ItemEnergeticShearsConfig.shearConsumption, false);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemStack, BlockPos pos, Player player) {
        IForgeShearable target;
        if (player.f_19853_.f_46443_ || player.m_7500_() || !this.canShear(itemStack)) {
            return false;
        }
        Block block = player.f_19853_.m_8055_(pos).m_60734_();
        if (block instanceof IForgeShearable && (target = (IForgeShearable)block).isShearable(itemStack, player.f_19853_, pos)) {
            List drops = target.onSheared(player, itemStack, player.f_19853_, pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)itemStack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity entityitem = new ItemEntity(player.f_19853_, (double)pos.m_123341_() + d, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, stack);
                entityitem.m_32060_();
                player.f_19853_.m_7967_((Entity)entityitem);
            }
            this.consumeOnShear(itemStack);
            player.m_21008_(player.m_7655_(), itemStack);
            player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
            player.f_19853_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return true;
        }
        return false;
    }

    public float m_8102_(ItemStack itemStack, BlockState state) {
        float factor = this.canShear(itemStack) ? 1.5f : 0.1f;
        float superSpeed = super.m_8102_(itemStack, state);
        if (superSpeed != 1.0f) {
            return superSpeed * factor;
        }
        return superSpeed;
    }

    public boolean m_6813_(ItemStack itemStack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.f_46443_) {
            this.consumeOnShear(itemStack);
        }
        Block block = state.m_60734_();
        return !state.m_204336_(BlockTags.f_13035_) && block != Blocks.f_50033_ && block != Blocks.f_50034_ && block != Blocks.f_50035_ && block != Blocks.f_50036_ && block != Blocks.f_50191_ && block != Blocks.f_50267_ && !state.m_204336_(BlockTags.f_13089_) ? super.m_6813_(itemStack, worldIn, state, pos, entityLiving) : true;
    }

    public boolean m_8096_(BlockState blockIn) {
        return Items.f_42574_.m_8096_(blockIn);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        LazyOptional energyCapability = entity.getCapability(CapabilityEnergy.ENERGY);
        if (energyCapability.isPresent()) {
            IEnergyStorage itemEnergy;
            IEnergyStorage entityEnergy = (IEnergyStorage)energyCapability.orElse(null);
            int moved = entityEnergy.extractEnergy((itemEnergy = this.getEnergyStorage(itemStack)).receiveEnergy(entityEnergy.extractEnergy(ItemEnergeticShearsConfig.usageTransferAmount, true), false), false);
            if (moved > 0) {
                player.m_21008_(hand, itemStack);
                entity.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.canShear(itemStack) && entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)entity;
            BlockPos pos = new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (target.isShearable(itemStack, entity.f_19853_, pos)) {
                List drops = target.onSheared(player, itemStack, entity.f_19853_, pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)itemStack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    ItemEntity ent = entity.m_5552_(stack, 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
                this.consumeOnShear(itemStack);
                player.m_21008_(hand, itemStack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        double amount = energyStorage.getEnergyStored();
        double capacity = energyStorage.getMaxEnergyStored();
        return Math.round((float)amount * 13.0f / (float)capacity);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new DefaultCapabilityProvider(() -> CapabilityEnergy.ENERGY, (Object)new EnergyStorageItem(ItemEnergeticShearsConfig.capacity, stack));
    }
}

