/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.energeticsheep.block.BlockEnergeticWool;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheep;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepConfig;
import org.cyclops.energeticsheep.item.ItemEnergeticShears;

public class ItemBlockEnergeticWool
extends BlockItem {
    public ItemBlockEnergeticWool(BlockEnergeticWool block, Item.Properties builder) {
        super((Block)block, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(itemStack, worldIn, tooltip, flagIn);
        if (CapabilityEnergy.ENERGY != null) {
            IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
            int amount = energyStorage.getEnergyStored();
            String line = String.format("%,d", amount) + " " + L10NHelpers.localize((String)"general.energeticsheep.energy_unit", (Object[])new Object[0]);
            tooltip.add((Component)Component.m_237113_((String)line).m_130940_(IInformationProvider.ITEM_PREFIX));
        }
        L10NHelpers.addOptionalInfo(tooltip, (String)"block.energeticsheep.energetic_wool");
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        InteractionResult result = ItemEnergeticShears.transferEnergy(context.m_43723_(), context.m_8083_(), context.m_43719_(), context.m_43724_());
        if (result == null) {
            return super.onItemUseFirst(stack, context);
        }
        return result;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new DefaultCapabilityProvider(() -> CapabilityEnergy.ENERGY, (Object)new EnergyStorage(EntityEnergeticSheep.getCapacity(((BlockEnergeticWool)this.m_40614_()).getColor(), EntityEnergeticSheepConfig.woolBaseCapacity), stack));
    }

    public static class EnergyStorage
    implements IEnergyStorage {
        private final int capacity;
        private final ItemStack itemStack;

        public EnergyStorage(int capacity, ItemStack itemStack) {
            this.capacity = capacity;
            this.itemStack = itemStack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (maxExtract >= this.capacity) {
                if (!simulate) {
                    this.itemStack.m_41774_(1);
                }
                return this.capacity;
            }
            return 0;
        }

        public int getEnergyStored() {
            return this.capacity;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

